/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.TclFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class TclFolderInfoController
extends BaseController<TclFolderInfoDTO, TclFolderInfoService> {
    @RequestMapping(value={"/api/tcl/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TclFolderInfoDTO>> queryTclFolderInfoAll(TclFolderInfoDTO dto) {
        List outputVo = ((TclFolderInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/folder/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TclFolderInfoDTO>> queryList(TclFolderInfoDTO dto) {
        List outputVo = ((TclFolderInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/folder/info/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<TclFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        TclFolderInfoDTO inVo = new TclFolderInfoDTO();
        inVo.setFolderId(folderId);
        TclFolderInfoDTO outputVo = (TclFolderInfoDTO)((TclFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/folder/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody TclFolderInfoDTO inTclFolderInfoDTO) {
        int outputVo = ((TclFolderInfoService)this.getService()).deleteByPk((Object)inTclFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/folder/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody TclFolderInfoDTO inTclFolderInfoDTO) {
        this.setUserInfoToVO(inTclFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTclFolderInfoDTO.setLastModifyUser(userId);
        inTclFolderInfoDTO.setLastModifyTime(now);
        int outputVo = ((TclFolderInfoService)this.getService()).updateByPk((Object)inTclFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/folder/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertTclFolderInfo(@RequestBody TclFolderInfoDTO inTclFolderInfoDTO) {
        this.setUserInfoToVO(inTclFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTclFolderInfoDTO.setCreateUser(userId);
        inTclFolderInfoDTO.setCreateTime(now);
        inTclFolderInfoDTO.setLastModifyUser(userId);
        inTclFolderInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inTclFolderInfoDTO.getFolderId())) {
            inTclFolderInfoDTO.setFolderId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((TclFolderInfoService)this.getService()).insert((Object)inTclFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/tcl/folder/info/merge"})
    @ResponseBody
    public ResponseData<Integer> folderMerge(@RequestBody TclFolderInfoDTO paramDTO, @RequestParam(value="type") String type) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((TclFolderInfoService)this.getService()).folderMerge(paramDTO, type);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/tcl/folder/info/move"})
    @ResponseBody
    public ResponseData<Integer> folderMove(@RequestBody TclFolderInfoDTO paramDTO) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((TclFolderInfoService)this.getService()).folderMove(paramDTO);
        return this.getResponseData(outputVo);
    }
}

