/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.web.controller.api;

import com.irdstudio.allinrdm.admin.console.facade.RdmWexinSubscribeService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWexinSubscribeDTO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmWexinSubscribeController
extends BaseController<RdmWexinSubscribeDTO, RdmWexinSubscribeService> {
    @Autowired
    private AllinCloudPortalClient portalClient;

    @RequestMapping(value={"/api/rdm/wexin/subscribes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmWexinSubscribeDTO>> queryRdmWexinSubscribeAll(RdmWexinSubscribeDTO dto) {
        List outputVo = ((RdmWexinSubscribeService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/wexin/subscribe/{actorno}/{wexinOpenid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmWexinSubscribeDTO> queryByPk(@PathVariable(value="actorno") String actorno, @PathVariable(value="wexinOpenid") String wexinOpenid) {
        RdmWexinSubscribeDTO inVo = new RdmWexinSubscribeDTO();
        inVo.setActorno(actorno);
        inVo.setWexinOpenid(wexinOpenid);
        RdmWexinSubscribeDTO outputVo = (RdmWexinSubscribeDTO)((RdmWexinSubscribeService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/wexin/subscribe"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmWexinSubscribeDTO inRdmWexinSubscribeDTO) {
        int outputVo = ((RdmWexinSubscribeService)this.getService()).deleteByPk((Object)inRdmWexinSubscribeDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/wexin/subscribe"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmWexinSubscribeDTO inRdmWexinSubscribeDTO) {
        int outputVo = ((RdmWexinSubscribeService)this.getService()).updateByPk((Object)inRdmWexinSubscribeDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/wexin/subscribe"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmWexinSubscribe(@RequestBody RdmWexinSubscribeDTO inRdmWexinSubscribeDTO) {
        RdmWexinSubscribeDTO oldSubscribe;
        SUserDTO userInfo;
        inRdmWexinSubscribeDTO.setSubscribeTime(CurrentDateUtil.getCurrentTime());
        if (StringUtils.isBlank((CharSequence)inRdmWexinSubscribeDTO.getWexinOpenid()) && (userInfo = this.portalClient.querySUserByPk(inRdmWexinSubscribeDTO.getActorno())) != null) {
            inRdmWexinSubscribeDTO.setWexinOpenid(userInfo.getWexinOpenid());
        }
        if ((oldSubscribe = (RdmWexinSubscribeDTO)((RdmWexinSubscribeService)this.getService()).queryByPk((Object)inRdmWexinSubscribeDTO)) != null) {
            int outputVo = ((RdmWexinSubscribeService)this.getService()).updateByPk((Object)inRdmWexinSubscribeDTO);
            return this.getResponseData(outputVo);
        }
        int outputVo = ((RdmWexinSubscribeService)this.getService()).insert((Object)inRdmWexinSubscribeDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/wexin/subscribe/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSubscribeList(@RequestBody List<RdmWexinSubscribeDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            SUserDTO userInfo = this.portalClient.querySUserByPk(list.get(0).getActorno());
            for (RdmWexinSubscribeDTO inRdmWexinSubscribeDTO : list) {
                RdmWexinSubscribeDTO oldSubscribe;
                inRdmWexinSubscribeDTO.setSubscribeTime(CurrentDateUtil.getCurrentTime());
                if (StringUtils.isBlank((CharSequence)inRdmWexinSubscribeDTO.getWexinOpenid()) && userInfo != null) {
                    inRdmWexinSubscribeDTO.setWexinOpenid(userInfo.getWexinOpenid());
                }
                if ((oldSubscribe = (RdmWexinSubscribeDTO)((RdmWexinSubscribeService)this.getService()).queryByPk((Object)inRdmWexinSubscribeDTO)) != null) {
                    if (oldSubscribe.getSubscribe() == null) {
                        oldSubscribe.setSubscribe(Integer.valueOf(0));
                    }
                    inRdmWexinSubscribeDTO.setSubscribe(Integer.valueOf(inRdmWexinSubscribeDTO.getSubscribe() + oldSubscribe.getSubscribe()));
                    outputVo += ((RdmWexinSubscribeService)this.getService()).updateByPk((Object)inRdmWexinSubscribeDTO);
                    continue;
                }
                outputVo += ((RdmWexinSubscribeService)this.getService()).insert((Object)inRdmWexinSubscribeDTO);
            }
        }
        return this.getResponseData(outputVo);
    }
}

