/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class ModelFolderInfoController
extends BaseController<ModelFolderInfoDTO, ModelFolderInfoService> {
    @PostMapping(value={"/api/model/folder/info"})
    @ResponseBody
    public ResponseData<Integer> insertModelFolderInfo(@RequestBody ModelFolderInfoDTO inModelFolderInfoVo) {
        ModelFolderInfoDTO inVo = new ModelFolderInfoDTO();
        inVo.setFolderId(inModelFolderInfoVo.getFolderAbvId());
        inModelFolderInfoVo.setFolderId(UUIDUtil.getUUID());
        inModelFolderInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inModelFolderInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inModelFolderInfoVo.setLastModifyUser(inModelFolderInfoVo.getCreateUser());
        inModelFolderInfoVo.setLastModifyTime(inModelFolderInfoVo.getCreateTime());
        int outputVo = ((ModelFolderInfoService)this.getService()).insert((Object)inModelFolderInfoVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/api/model/folder/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ModelFolderInfoDTO inModelFolderInfoVo) {
        int outputVo = ((ModelFolderInfoService)this.getService()).deleteByPk((Object)inModelFolderInfoVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/model/folder/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ModelFolderInfoDTO inModelFolderInfoVo) {
        ModelFolderInfoDTO inVo = new ModelFolderInfoDTO();
        inVo.setFolderId(inModelFolderInfoVo.getFolderAbvId());
        inModelFolderInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelFolderInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((ModelFolderInfoService)this.getService()).updateByPk((Object)inModelFolderInfoVo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/model/folder/info/merge"})
    @ResponseBody
    public ResponseData<Integer> folderMerge(@RequestBody ModelFolderInfoDTO inModelFolderInfoVo, @RequestParam(value="type") String type) {
        this.setUserInfoToVO(inModelFolderInfoVo);
        int outputVo = ((ModelFolderInfoService)this.getService()).folderMerge(inModelFolderInfoVo, type);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/model/folder/info/move"})
    @ResponseBody
    public ResponseData<Integer> folderMove(@RequestBody ModelFolderInfoDTO inModelFolderInfoVo) {
        this.setUserInfoToVO(inModelFolderInfoVo);
        int outputVo = ((ModelFolderInfoService)this.getService()).folderMove(inModelFolderInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/folder/info/{folderId}"})
    @ResponseBody
    public ResponseData<ModelFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        ModelFolderInfoDTO inVo = new ModelFolderInfoDTO();
        inVo.setFolderId(folderId);
        ModelFolderInfoDTO outputVo = (ModelFolderInfoDTO)((ModelFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/folder/info/check/{folderId}"})
    @ResponseBody
    public ResponseData<String> checkByPk(@PathVariable(value="folderId") String folderId) {
        ResponseData rsp = new ResponseData();
        ModelFolderInfoDTO inVo = new ModelFolderInfoDTO();
        inVo.setFolderId(folderId);
        ModelFolderInfoDTO folderVo = (ModelFolderInfoDTO)((ModelFolderInfoService)this.getService()).queryByPk((Object)inVo);
        if (folderVo.getFolderAbvId().equals(folderVo.getAppId())) {
            rsp.fail("\u5f53\u524d\u76ee\u5f55\u4e3a\u8868\u6a21\u578b\u6839\u76ee\u5f55,\u4e0d\u53ef\u5220\u9664!");
            return rsp;
        }
        if (((ModelFolderInfoService)this.getService()).isHaveSubFolder(folderVo.getFolderId()) || ((ModelFolderInfoService)this.getService()).isHaveTableModel(folderVo.getFolderId())) {
            rsp.fail("\u9700\u8981\u5148\u5220\u9664\u76ee\u5f55\u4e0b\u7684\u5b50\u76ee\u5f55\u53ca\u8868\u6a21\u578b\u540e\u65b9\u53ef\u5220\u9664\u5f53\u524d\u76ee\u5f55!");
            return rsp;
        }
        return this.getResponseData("\u53ef\u4ee5\u5220\u9664!");
    }

    @RequestMapping(value={"/api/model/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelFolderInfoDTO>> queryModelFolderInfoAll(ModelFolderInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelFolderInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/folder/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelFolderInfoDTO>> queryList(ModelFolderInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelFolderInfoService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }
}

