/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.AppModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppModelInfoDTO;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class AppModelInfoController
extends BaseController<AppModelInfoDTO, AppModelInfoService> {
    @PostMapping(value={"/api/app/model/info/{appId}"})
    @ResponseBody
    public ResponseData<String> insertAppModelInfo(@PathVariable(value="appId") String appId, @RequestBody AppModelInfoDTO inAppModelInfoDTO) {
        inAppModelInfoDTO.setCreateUser(inAppModelInfoDTO.getLoginUserId());
        inAppModelInfoDTO.setCreateTime(TimeUtil.getCurrentDateTime());
        inAppModelInfoDTO.setAppModelId(UUIDUtil.getUUID());
        inAppModelInfoDTO.setAppId(appId);
        int outputDTO = ((AppModelInfoService)this.getService()).insert((Object)inAppModelInfoDTO);
        return this.getResponseData(inAppModelInfoDTO.getAppModelId());
    }

    @DeleteMapping(value={"/api/app/model/info/{appId}"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@PathVariable(value="appId") String appId, @RequestBody AppModelInfoDTO inAppModelInfoDTO) {
        inAppModelInfoDTO.setAppId(appId);
        int outputDTO = ((AppModelInfoService)this.getService()).deleteByPk((Object)inAppModelInfoDTO);
        return this.getResponseData(outputDTO);
    }

    @PutMapping(value={"/api/app/model/info/{appId}"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@PathVariable(value="appId") String appId, @RequestBody AppModelInfoDTO inAppModelInfoDTO) {
        inAppModelInfoDTO.setAppId(appId);
        int outputDTO = ((AppModelInfoService)this.getService()).updateByPk((Object)inAppModelInfoDTO);
        return this.getResponseData(outputDTO);
    }

    @GetMapping(value={"/api/app/model/info/{appModelId}/{appId}"})
    @ResponseBody
    public ResponseData<AppModelInfoDTO> queryByPk(@PathVariable(value="appId") String appId, @PathVariable(value="appModelId") String appModelId) {
        AppModelInfoDTO inDTO = new AppModelInfoDTO();
        inDTO.setAppModelId(appModelId);
        inDTO.setAppId(appId);
        AppModelInfoDTO outputDTO = (AppModelInfoDTO)((AppModelInfoService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/app/model/infos/{appId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<AppModelInfoDTO>> queryAppModelInfoAll(@PathVariable(value="appId") String appId, AppModelInfoDTO vo) {
        List outputDTO = null;
        vo.setAppId(appId);
        outputDTO = ((AppModelInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @GetMapping(value={"/api/app/model/info/external/{appModelId}/{appId}"})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryExternalService(@PathVariable(value="appId") String appId, @PathVariable(value="appModelId") String appModelId) {
        try {
            Map result = ((AppModelInfoService)this.getService()).queryExternalServiceFlowChart(appId, appModelId);
            return this.getResponseData(result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5916\u90e8\u670d\u52a1\u76f8\u5173\u4fe1\u606f\u5f02\u5e38 appId {} appModelId {}", new Object[]{appId, appModelId, e});
            ResponseData re = this.getResponseData(null);
            re.setMessage(e.getMessage());
            return re;
        }
    }

    @PostMapping(value={"/api/app/model/info/external/{appId}"})
    @ResponseBody
    public ResponseData<Boolean> saveExternalService(@PathVariable(value="appId") String appId, @RequestBody Map<String, Object> flowData) {
        try {
            boolean flag = ((AppModelInfoService)this.getService()).saveExternalServiceFlowChart(appId, flowData);
            return this.getResponseData(flag);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6d41\u7a0b\u6570\u636e\u4fe1\u606f\u5f02\u5e38 appId {} ", (Object)appId, (Object)e);
            ResponseData re = this.getResponseData(null);
            re.setMessage(e.getMessage());
            return re;
        }
    }

    @PostMapping(value={"/api/app/model/info/osrv/field/{appId}"})
    @ResponseBody
    public ResponseData<List<BaseInfo>> queryPopOsrvFieldChooseData(@PathVariable(value="appId") String appId, @RequestBody Map<String, Object> params) {
        try {
            String appModelId = MapUtils.getString(params, (Object)"appModelId");
            String ioType = MapUtils.getString(params, (Object)"ioType");
            if (StringUtils.isBlank((CharSequence)appModelId)) {
                return this.getResponseData(Collections.emptyList());
            }
            AppModelInfoDTO osrvParam = new AppModelInfoDTO();
            osrvParam.setAppModelId(appModelId);
            osrvParam.setAppId(appId);
            AppModelInfoDTO osrv = (AppModelInfoDTO)((AppModelInfoService)this.getService()).queryByPk((Object)osrvParam);
            ArrayList treeList = new ArrayList();
            return this.getResponseData(treeList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5916\u90e8\u670d\u52a1 \u8282\u70b9\u7684\u76f8\u5173\u5b57\u6bb5\u6811\u72b6\u4fe1\u606f appId {} ", (Object)appId, (Object)e);
            ResponseData re = this.getResponseData(null);
            re.setMessage(e.getMessage());
            return re;
        }
    }

    @RequestMapping(value={"/client/AppModelInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody AppModelInfoDTO param) {
        return ((AppModelInfoService)this.getService()).deleteByCond(param);
    }
}

