/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.facade.CardDevInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CardDevInfoDTO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class CardDevInfoController
extends BaseController<CardDevInfoDTO, CardDevInfoService> {
    @RequestMapping(value={"/api/card/dev/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<CardDevInfoDTO>> queryCardDevInfoAll(CardDevInfoDTO dto) {
        List outputVo = ((CardDevInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/card/dev/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<CardDevInfoDTO>> queryList(CardDevInfoDTO dto) {
        List outputVo = ((CardDevInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/card/dev/info/{cardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<CardDevInfoDTO> queryByPk(@PathVariable(value="cardId") String cardId) {
        CardDevInfoDTO inVo = new CardDevInfoDTO();
        inVo.setCardId(cardId);
        CardDevInfoDTO outputVo = (CardDevInfoDTO)((CardDevInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/card/dev/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody CardDevInfoDTO inCardDevInfoDTO) {
        int outputVo = ((CardDevInfoService)this.getService()).deleteByPk((Object)inCardDevInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/card/dev/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody CardDevInfoDTO inCardDevInfoDTO) {
        this.setUserInfoToVO(inCardDevInfoDTO);
        inCardDevInfoDTO.setLastModifyUser(inCardDevInfoDTO.getLoginUserId());
        inCardDevInfoDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((CardDevInfoService)this.getService()).updateByPk((Object)inCardDevInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/card/dev/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertCardDevInfo(@RequestBody CardDevInfoDTO inCardDevInfoDTO) {
        if (StringUtils.isBlank((CharSequence)inCardDevInfoDTO.getCardId())) {
            AllinCloudPortalClient allinCloudPortalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
            inCardDevInfoDTO.setCardId(allinCloudPortalClient.nextSequence("CARD_ID", null));
        }
        this.setUserInfoToVO(inCardDevInfoDTO);
        inCardDevInfoDTO.setCreateUser(inCardDevInfoDTO.getLoginUserId());
        inCardDevInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inCardDevInfoDTO.setLastModifyUser(inCardDevInfoDTO.getLoginUserId());
        inCardDevInfoDTO.setLastModifyTime(inCardDevInfoDTO.getCreateTime());
        int outputVo = ((CardDevInfoService)this.getService()).insert((Object)inCardDevInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/card/info/change/belong/deletes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryBeLongDeleteFiles(CardDevInfoDTO dto) {
        String appId = dto.getAppId();
        String id = StringUtils.isNotBlank((CharSequence)dto.getPageId()) ? dto.getPageId() : dto.getCardId();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            ArrayList result = new ArrayList();
            files.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filePath", f.getAbsolutePath().replaceFirst(dir.getAbsolutePath(), "").replaceAll(File.separator, "/"));
                map.put("fileName", f.getName());
                result.add(map);
            });
            if (CollectionUtils.isNotEmpty(result)) {
                Map map = (Map)result.get(0);
                map.put("total", result.size());
            }
            return this.getResponseData(result);
        }
        return this.getResponseData(Collections.emptyList());
    }

    @RequestMapping(value={"/api/card/info/change/belong/deletes/confirm"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<String> beLongDeleteFilesConfirm(@RequestBody CardDevInfoDTO dto) {
        String appId = dto.getAppId();
        String id = StringUtils.isNotBlank((CharSequence)dto.getPageId()) ? dto.getPageId() : dto.getCardId();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            FileUtils.deleteQuietly((File)dir);
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(dto.getAppId());
            appRepoPullTask.syncRun();
            String appPath = appRepoPullTask.getAppPath();
            try {
                Files.move(new File(appPath).toPath(), dir.toPath(), new CopyOption[0]);
                for (File deleteFile : files) {
                    if (!deleteFile.exists()) continue;
                    FileUtils.deleteQuietly((File)deleteFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getResponseData("\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/api/card/info/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<CardDevInfoDTO> validate(@RequestBody CardDevInfoDTO dto) {
        dto = (CardDevInfoDTO)((CardDevInfoService)this.getService()).queryByPk((Object)dto);
        boolean flag = ((CardDevInfoService)this.getService()).validate(dto);
        return this.getResponseData(dto);
    }

    @RequestMapping(value={"/api/card/info/validate/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> validateList(@RequestBody CardDevInfoDTO dto) {
        dto.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List cardList = ((CardDevInfoService)this.getService()).queryListByPage((Object)dto);
        cardList.forEach(this::validate);
        return this.getResponseData(cardList.size());
    }
}

