/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalUpdateService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.IsrvEvalUpdateDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class IsrvEvalUpdateController
extends BaseController<IsrvEvalUpdateDTO, IsrvEvalUpdateService> {
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @RequestMapping(value={"/api/isrv/eval/updates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<IsrvEvalUpdateDTO>> queryIsrvEvalUpdateAll(IsrvEvalUpdateDTO vo) {
        List outputVo = ((IsrvEvalUpdateService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/eval/update/{recordKeyid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<IsrvEvalUpdateDTO> queryByPk(@PathVariable(value="recordKeyid") String recordKeyid) {
        IsrvEvalUpdateDTO inVo = new IsrvEvalUpdateDTO();
        inVo.setRecordKeyid(recordKeyid);
        IsrvEvalUpdateDTO outputVo = (IsrvEvalUpdateDTO)((IsrvEvalUpdateService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/eval/update"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody IsrvEvalUpdateDTO inIsrvEvalUpdateVo) {
        int outputVo = ((IsrvEvalUpdateService)this.getService()).deleteByPk((Object)inIsrvEvalUpdateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/eval/update"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody IsrvEvalUpdateDTO inIsrvEvalUpdateVo) {
        int outputVo = ((IsrvEvalUpdateService)this.getService()).updateByPk((Object)inIsrvEvalUpdateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/eval/update/ioflag"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> updateByFieldIoFlag(@RequestParam(value="fieldId") String fieldId, @RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="ioType") String ioType, @RequestParam(value="ioFlag") String ioFlag) {
        int num = ((IsrvEvalUpdateService)this.getService()).updateByFieldIoFlag(fieldId, srvModelId, ioType, ioFlag);
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/isrv/eval/update/ioflags"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> updateByFieldIoFlags(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="ioType") String ioType, @RequestParam(value="ioFlag") String ioFlag) {
        SrvModelInfoDTO model = new SrvModelInfoDTO();
        model.setSrvModelId(srvModelId);
        model = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)model);
        SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)model.getSrvModelType());
        if (SrvModelTypeEnum.UPDATE_BY_PK != srvModelTypeEnum && SrvModelTypeEnum.UPDATE_SINGLE != srvModelTypeEnum) {
            return this.getResponseData(1);
        }
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(objectId);
        List fieldList = this.modelTableFieldService.queryList((Object)fieldParam);
        int num = 0;
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            for (ModelTableFieldDTO field : fieldList) {
                num += ((IsrvEvalUpdateService)this.getService()).updateByFieldIoFlag(field.getFieldId(), srvModelId, ioType, ioFlag);
            }
        }
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/isrv/eval/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertIsrvEvalUpdate(@RequestBody IsrvEvalUpdateDTO inIsrvEvalUpdateVo) {
        int outputVo = ((IsrvEvalUpdateService)this.getService()).insert((Object)inIsrvEvalUpdateVo);
        return this.getResponseData(outputVo);
    }
}

