/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageResourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageResourceDTO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageResourceController
extends BaseController<PageResourceDTO, PageResourceService> {
    @RequestMapping(value={"/api/page/resources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageResourceDTO>> queryPageResourceAll(PageResourceDTO dto) {
        List outputVo = ((PageResourceService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/resource/{pageId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageResourceDTO> queryByPk(@PathVariable(value="pageId") String pageId) {
        PageResourceDTO inVo = new PageResourceDTO();
        inVo.setPageId(pageId);
        PageResourceDTO outputVo = (PageResourceDTO)((PageResourceService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/resource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageResourceDTO inPageResourceDTO) {
        int outputVo = ((PageResourceService)this.getService()).deleteByPk((Object)inPageResourceDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/resource"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageResourceDTO inPageResourceDTO) {
        int outputVo = ((PageResourceService)this.getService()).updateByPk((Object)inPageResourceDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/resource"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPageResource(@RequestBody PageResourceDTO inPageResourceDTO) {
        if (StringUtils.isBlank((CharSequence)inPageResourceDTO.getPageId())) {
            inPageResourceDTO.setPageId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PageResourceService)this.getService()).insert((Object)inPageResourceDTO);
        return this.getResponseData(outputVo);
    }
}

