/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.QryModelRelationService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelRelationDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QryModelRelationController
extends BaseController<QryModelRelationDTO, QryModelRelationService> {
    @RequestMapping(value={"/api/qry/model/relations"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QryModelRelationDTO>> queryQryModelRelationAll(QryModelRelationDTO vo) {
        List outputDTO = ((QryModelRelationService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/relation/{relationId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QryModelRelationDTO> queryByPk(@PathVariable(value="relationId") String relationId, @RequestParam(value="qryId") String qryId) {
        QryModelRelationDTO inDTO = new QryModelRelationDTO();
        inDTO.setRelationId(relationId);
        inDTO.setQryId(qryId);
        QryModelRelationDTO outputDTO = (QryModelRelationDTO)((QryModelRelationService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/relation"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QryModelRelationDTO inQryModelRelationDTO) {
        int outputDTO = ((QryModelRelationService)this.getService()).deleteByPk((Object)inQryModelRelationDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/relation"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QryModelRelationDTO inQryModelRelationDTO) {
        inQryModelRelationDTO.setLastUpdateUser(inQryModelRelationDTO.getLoginUserId());
        inQryModelRelationDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelRelationService)this.getService()).updateByPk((Object)inQryModelRelationDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/relation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertQryModelRelation(@RequestBody QryModelRelationDTO inQryModelRelationDTO) {
        if (StringUtils.isBlank((CharSequence)inQryModelRelationDTO.getRelationId())) {
            inQryModelRelationDTO.setRelationId(UUIDUtil.getUUID());
            inQryModelRelationDTO.setCreateUser(inQryModelRelationDTO.getLoginUserId());
            inQryModelRelationDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            int outputDTO = ((QryModelRelationService)this.getService()).insert((Object)inQryModelRelationDTO);
            return this.getResponseData(outputDTO);
        }
        return this.updateByPk(inQryModelRelationDTO);
    }
}

