/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.RptModelItemService;
import com.irdstudio.allinrdm.dev.console.facade.dto.RptModelItemDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RptModelItemController
extends BaseController<RptModelItemDTO, RptModelItemService> {
    @RequestMapping(value={"/api/rpt/dev/items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RptModelItemDTO>> queryRptModelItemAll(RptModelItemDTO dto) {
        List outputVo = ((RptModelItemService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rpt/dev/items/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RptModelItemDTO>> queryList(RptModelItemDTO dto) {
        List outputVo = ((RptModelItemService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rpt/dev/item/{rptItemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RptModelItemDTO> queryByPk(@PathVariable(value="rptItemId") String rptItemId) {
        RptModelItemDTO inVo = new RptModelItemDTO();
        inVo.setRptItemId(rptItemId);
        RptModelItemDTO outputVo = (RptModelItemDTO)((RptModelItemService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rpt/dev/item"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RptModelItemDTO inRptModelItemDTO) {
        int outputVo = ((RptModelItemService)this.getService()).deleteByPk((Object)inRptModelItemDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rpt/dev/item"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RptModelItemDTO inRptModelItemDTO) {
        this.setUserInfoToVO(inRptModelItemDTO);
        inRptModelItemDTO.setLastUpdateUser(inRptModelItemDTO.getLoginUserId());
        inRptModelItemDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((RptModelItemService)this.getService()).updateByPk((Object)inRptModelItemDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rpt/dev/item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertRptModelItem(@RequestBody RptModelItemDTO inRptModelItemDTO) {
        this.setUserInfoToVO(inRptModelItemDTO);
        inRptModelItemDTO.setCreateUser(inRptModelItemDTO.getLoginUserId());
        inRptModelItemDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inRptModelItemDTO.setLastUpdateUser(inRptModelItemDTO.getLoginUserId());
        inRptModelItemDTO.setLastUpdateTime(inRptModelItemDTO.getCreateTime());
        if (StringUtils.isBlank((CharSequence)inRptModelItemDTO.getRptItemId())) {
            inRptModelItemDTO.setRptItemId(UUIDUtil.getShortUUID());
        }
        if (inRptModelItemDTO.getOrderValue() == null) {
            RptModelItemDTO query = new RptModelItemDTO();
            query.setRptModelId(inRptModelItemDTO.getRptModelId());
            query.setSize(Integer.valueOf(1));
            List list = ((RptModelItemService)this.getService()).queryListByPage((Object)query);
            inRptModelItemDTO.setOrderValue(Integer.valueOf(query.getTotal() + 1));
        }
        int outputVo = ((RptModelItemService)this.getService()).insert((Object)inRptModelItemDTO);
        return this.getResponseData(inRptModelItemDTO.getRptItemId());
    }

    @RequestMapping(value={"/api/rpt/dev/item/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveList(@RequestBody List<RptModelItemDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int outputVo = 0;
            String userId = this.getUserInfo().getUserId();
            String now = CurrentDateUtil.getTodayDateEx2();
            for (RptModelItemDTO item : list) {
                int re;
                if (StringUtils.isNotBlank((CharSequence)item.getRptItemId())) {
                    item.setLastUpdateUser(userId);
                    item.setLastUpdateTime(now);
                    re = ((RptModelItemService)this.getService()).updateByPk((Object)item);
                    if (re <= 0) continue;
                    outputVo += re;
                    continue;
                }
                item.setCreateUser(userId);
                item.setCreateTime(now);
                re = ((RptModelItemService)this.getService()).insert((Object)item);
                if (re <= 0) continue;
                outputVo += re;
            }
            return this.getResponseData(outputVo);
        }
        return this.getResponseData(0);
    }
}

