/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.project.console.facade.RdmRequirementInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmRequirementInfoDTO;
import com.irdstudio.allinrdm.project.console.types.ReqStat;
import com.irdstudio.allinrdm.project.console.types.ReqType;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class RdmRequirementInfoController
extends BaseController<RdmRequirementInfoDTO, RdmRequirementInfoService> {
    @RequestMapping(value={"/api/rdm/requirement/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmRequirementInfoDTO>> queryRdmRequirementInfoAll(RdmRequirementInfoDTO dto) {
        List outputVo = ((RdmRequirementInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/requirement/info/{reqId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmRequirementInfoDTO> queryByPk(@PathVariable(value="reqId") String reqId) {
        RdmRequirementInfoDTO inVo = new RdmRequirementInfoDTO();
        inVo.setReqId(reqId);
        RdmRequirementInfoDTO outputVo = (RdmRequirementInfoDTO)((RdmRequirementInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/requirement/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmRequirementInfoDTO inRdmRequirementInfoDTO) {
        int outputVo = ((RdmRequirementInfoService)this.getService()).deleteByPk((Object)inRdmRequirementInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/requirement/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmRequirementInfoDTO inRdmRequirementInfoDTO) {
        this.setUserInfoToVO(inRdmRequirementInfoDTO);
        inRdmRequirementInfoDTO.setLastUpdateUser(inRdmRequirementInfoDTO.getLoginUserId());
        inRdmRequirementInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((RdmRequirementInfoService)this.getService()).updateByPk((Object)inRdmRequirementInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/requirement/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmRequirementInfo(@RequestBody RdmRequirementInfoDTO inRdmRequirementInfoDTO) {
        this.setUserInfoToVO(inRdmRequirementInfoDTO);
        inRdmRequirementInfoDTO.setCreateUser(inRdmRequirementInfoDTO.getLoginUserId());
        inRdmRequirementInfoDTO.setCreateUserName(inRdmRequirementInfoDTO.getLoginUserName());
        inRdmRequirementInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inRdmRequirementInfoDTO.setLastUpdateUser(inRdmRequirementInfoDTO.getLoginUserId());
        inRdmRequirementInfoDTO.setLastUpdateTime(inRdmRequirementInfoDTO.getCreateTime());
        if (StringUtils.isBlank((CharSequence)inRdmRequirementInfoDTO.getReqId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            if (StringUtils.isNotBlank((CharSequence)inRdmRequirementInfoDTO.getProjectId())) {
                inRdmRequirementInfoDTO.setReqId(seqService.nextSequence("RDM-PRJ-REQ-SEQ", inRdmRequirementInfoDTO.getProjectId()));
            } else {
                inRdmRequirementInfoDTO.setReqId(seqService.nextSequence("RDM-REQ-SEQ", inRdmRequirementInfoDTO.getProjectId()));
            }
        }
        String incharge = inRdmRequirementInfoDTO.getIncharge();
        String inchargeName = inRdmRequirementInfoDTO.getInchargeName();
        if (StringUtils.isNotBlank((CharSequence)incharge)) {
            inRdmRequirementInfoDTO.setIncharge(null);
            inRdmRequirementInfoDTO.setInchargeName(null);
        }
        int outputVo = ((RdmRequirementInfoService)this.getService()).insert((Object)inRdmRequirementInfoDTO);
        inRdmRequirementInfoDTO.setIncharge(incharge);
        inRdmRequirementInfoDTO.setInchargeName(inchargeName);
        ((RdmRequirementInfoService)this.getService()).updateByPk((Object)inRdmRequirementInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/requirement/info/incharges"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmReqInchargeGroupByPage(RdmRequirementInfoDTO param) {
        List outputVo = ((RdmRequirementInfoService)this.getService()).queryRdmReqInchargeGroupByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/requirement/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryByPk() {
        return this.getResponseData(((RdmRequirementInfoService)this.getService()).queryMaxId());
    }

    @PostMapping(value={"/api/rdm/requirement/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="appId") String appId, @RequestParam(value="reqCategory", required=false) String reqCategory, @RequestParam(value="excelUploadType") String excelUploadType, @RequestPart(value="file") MultipartFile file) {
        try {
            String userId = this.getUserInfo().getUserId();
            RdmRequirementItemListener listener = new RdmRequirementItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), ExcelItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmRequirementInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    RdmRequirementInfoDTO delParam = new RdmRequirementInfoDTO();
                    ((RdmRequirementInfoService)this.getService()).deleteByAll(delParam);
                }
                SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
                list.stream().forEach(el -> {
                    el.setLoginUserId(userId);
                    el.setReqCategory(reqCategory);
                    el.setReqStat(ReqStat.Wait.getCode());
                    if (StringUtils.isNotBlank((CharSequence)el.getProjectId())) {
                        el.setReqId(seqService.nextSequence("RDM-PRJ-REQ-SEQ", el.getProjectId()));
                    } else {
                        el.setReqId(seqService.nextSequence("RDM-REQ-SEQ", el.getProjectId()));
                    }
                });
                ((RdmRequirementInfoService)this.getService()).batchInsert(list);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u9700\u6c42\u6c60\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    @RequestMapping(value={"/api/rdm/requirement/info/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRequirementSummary(@RequestBody RdmRequirementInfoDTO param) {
        List homePageVOList = ((RdmRequirementInfoService)this.getService()).queryRequirementSummary(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/requirement/info/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmProjectSummaryByPage(RdmRequirementInfoDTO param) {
        List homePageVOList = ((RdmRequirementInfoService)this.getService()).queryRdmProjectSummaryByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/requirement/info/incharge/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmInchargeGroupByPage(RdmRequirementInfoDTO param) {
        List homePageVOList = ((RdmRequirementInfoService)this.getService()).queryRdmInchargeGroupByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/client/RdmRequirementInfoService/deleteByAll"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByAll(@RequestBody RdmRequirementInfoDTO rdmRequirementInfoDTO) {
        return ((RdmRequirementInfoService)this.getService()).deleteByAll(rdmRequirementInfoDTO);
    }

    public static class ExcelItem {
        @ExcelProperty(value={"\u9700\u6c42\u7f16\u53f7"})
        private String reqId;
        @ExcelProperty(value={"\u9700\u6c42\u6807\u7b7e"})
        private String tagName;
        @ExcelProperty(value={"\u9700\u6c42\u6807\u9898"})
        private String reqTitle;
        @ExcelProperty(value={"\u9700\u6c42\u5185\u5bb9"})
        private String reqContent;
        @ExcelProperty(value={"\u9700\u6c42\u72b6\u6001"})
        private String reqStatName;
        @ExcelProperty(value={"\u9700\u6c42\u6765\u6e90"})
        private String reqSourceName;
        @ExcelProperty(value={"\u9700\u6c42\u7c7b\u578b"})
        private String reqTypeName;
        @ExcelProperty(value={"\u5ba2\u6237"})
        private String reqCust;

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public String getReqTitle() {
            return this.reqTitle;
        }

        public void setReqTitle(String reqTitle) {
            this.reqTitle = reqTitle;
        }

        public String getReqContent() {
            return this.reqContent;
        }

        public void setReqContent(String reqContent) {
            this.reqContent = reqContent;
        }

        public String getReqStatName() {
            return this.reqStatName;
        }

        public void setReqStatName(String reqStatName) {
            this.reqStatName = reqStatName;
        }

        public String getReqSourceName() {
            return this.reqSourceName;
        }

        public void setReqSourceName(String reqSourceName) {
            this.reqSourceName = reqSourceName;
        }

        public String getReqCust() {
            return this.reqCust;
        }

        public void setReqCust(String reqCust) {
            this.reqCust = reqCust;
        }

        public String getReqId() {
            return this.reqId;
        }

        public void setReqId(String reqId) {
            this.reqId = reqId;
        }

        public String getReqTypeName() {
            return this.reqTypeName;
        }

        public void setReqTypeName(String reqTypeName) {
            this.reqTypeName = reqTypeName;
        }
    }

    public static class RdmRequirementItemListener
    extends AnalysisEventListener<ExcelItem> {
        private List<RdmRequirementInfoDTO> list = new ArrayList<RdmRequirementInfoDTO>();

        public List<RdmRequirementInfoDTO> getList() {
            return this.list;
        }

        public void invoke(ExcelItem data, AnalysisContext context) {
            RdmRequirementInfoDTO vo = new RdmRequirementInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setReqStat(ReqStat.codeByName((String)vo.getReqStatName()));
            vo.setReqType(ReqType.codeByName((String)vo.getReqTypeName()));
            if (StringUtils.isBlank((CharSequence)vo.getReqTitle())) {
                if (StringUtils.length((CharSequence)vo.getReqContent()) > 200) {
                    vo.setReqTitle(StringUtils.substring((String)vo.getReqContent(), (int)0, (int)195) + "...");
                } else {
                    vo.setReqTitle(vo.getReqContent());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getTagName())) {
                String tagName = vo.getTagName();
                tagName = StringUtils.replace((String)tagName, (String)"\u3001", (String)",");
                tagName = StringUtils.replace((String)tagName, (String)"\uff0c", (String)",");
                vo.setTagName(tagName);
            }
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

