/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.DevtypeInfoExecService;
import com.irdstudio.allinrdm.dev.console.facade.FnTypeInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.FnTypeInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.FnModelInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.NumberUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class FnModelInfoController
extends BaseController<FnModelInfoDTO, FnModelInfoService> {
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    private static ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();
    @Autowired
    private DevtypeInfoExecService devtypeInfoExecService;
    @Autowired
    private FnTypeInfoService fnTypeInfoService;

    @RequestMapping(value={"/api/fn/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FnModelInfoDTO>> queryFnModelInfoAll(FnModelInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getAppId(), (CharSequence)",")) {
            dto.setAppIdList(Arrays.asList(StringUtils.split((String)dto.getAppId(), (String)",")));
            dto.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getComId(), (CharSequence)",")) {
            dto.setComIdList(Arrays.asList(StringUtils.split((String)dto.getComId(), (String)",")));
            dto.setComId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getTableModelId(), (CharSequence)",")) {
            dto.setTableModelIds(Arrays.asList(StringUtils.split((String)dto.getTableModelId(), (String)",")));
            dto.setTableModelId(null);
        }
        List outputVo = ((FnModelInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/model/infos/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FnModelInfoDTO>> queryFnModelInfoAllNotPage(FnModelInfoDTO dto) {
        List outputVo = ((FnModelInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/model/info/{fnId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FnModelInfoDTO> queryByPk(@PathVariable(value="fnId") String fnId) {
        FnModelInfoDTO inVo = new FnModelInfoDTO();
        inVo.setFnId(fnId);
        FnModelInfoDTO outputVo = (FnModelInfoDTO)((FnModelInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/model/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FnModelInfoDTO inFnModelInfoDTO) {
        inFnModelInfoDTO = (FnModelInfoDTO)((FnModelInfoService)this.getService()).queryByPk((Object)inFnModelInfoDTO);
        boolean flag = this.devtypeInfoExecService.delete(inFnModelInfoDTO.getFnType1(), inFnModelInfoDTO.getFnType2(), this.getUserInfo().getUserId(), inFnModelInfoDTO.getFnId());
        int outputVo = ((FnModelInfoService)this.getService()).deleteByPk((Object)inFnModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/model/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FnModelInfoDTO inFnModelInfoDTO) {
        this.setUserInfoToVO(inFnModelInfoDTO);
        inFnModelInfoDTO.setUpdateUser(inFnModelInfoDTO.getLoginUserId());
        inFnModelInfoDTO.setUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((FnModelInfoService)this.getService()).updateByPk((Object)inFnModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/model/info/batch/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> queryBatchInsertStat(@RequestParam(value="key") String key) {
        Boolean re = (Boolean)taskDebounce.get(key);
        return this.getResponseData(re);
    }

    @RequestMapping(value={"/api/fn/model/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertFnModelInfo(@RequestParam(value="allSelected", required=false) String allSelected, @RequestParam(value="key", required=false) String key, @RequestBody FnModelInfoDTO inFnModelInfoDTO) {
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inFnModelInfoDTO);
        inFnModelInfoDTO.setCreateUser(userId);
        inFnModelInfoDTO.setCreateTime(now);
        inFnModelInfoDTO.setUpdateUser(userId);
        inFnModelInfoDTO.setUpdateTime(now);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            taskDebounce.put(key, true);
        }
        if (StringUtils.isBlank((CharSequence)inFnModelInfoDTO.getFnId())) {
            inFnModelInfoDTO.setFnId(UUIDUtil.getUUID());
        }
        int count = 0;
        if (CollectionUtils.isNotEmpty((Collection)inFnModelInfoDTO.getFnTypes())) {
            ModelTableInfoDTO tableParam;
            List tableList = Collections.emptyList();
            if (StringUtils.equals((CharSequence)allSelected, (CharSequence)YesOrNO.YES.getCode())) {
                tableParam = new ModelTableInfoDTO();
                tableParam.setAppId(inFnModelInfoDTO.getAppId());
                tableParam.setComId(inFnModelInfoDTO.getComId());
                tableParam.setObjectType(ObjectType.Table.getIntCode());
                tableList = this.modelTableInfoService.queryList((Object)tableParam);
            } else if (CollectionUtils.isNotEmpty((Collection)inFnModelInfoDTO.getTableModelIds())) {
                tableParam = new ModelTableInfoDTO();
                tableParam.setAppId(inFnModelInfoDTO.getAppId());
                tableParam.setComId(inFnModelInfoDTO.getComId());
                tableParam.setObjectIds(inFnModelInfoDTO.getTableModelIds());
                tableList = this.modelTableInfoService.queryAllByTableInfo(tableParam);
            }
            if (CollectionUtils.isNotEmpty(tableList)) {
                int len = 100;
                if (tableList.size() > len) {
                    int loop = NumberUtility.calcLoop((int)tableList.size(), (int)len);
                    ArrayList<Future> futureList = new ArrayList<Future>(loop);
                    int cur = 0;
                    for (int i = 1; i <= loop; ++i) {
                        int end = len * i;
                        if (end > tableList.size()) {
                            end = tableList.size();
                        }
                        List<ModelTableInfoDTO> sub = tableList.subList(cur, end);
                        cur += len;
                        Future future = this.applicationThreadPool.add((Callable)new BatchGenerateFnTask(sub, inFnModelInfoDTO));
                        futureList.add(future);
                    }
                    while (!futureList.isEmpty()) {
                        ArrayList<Future> newList = new ArrayList<Future>(loop);
                        for (Future f : futureList) {
                            if (f.isDone()) continue;
                            newList.add(f);
                        }
                        futureList = newList;
                    }
                    count = loop;
                } else {
                    Future future = this.applicationThreadPool.add((Callable)new BatchGenerateFnTask(tableList, inFnModelInfoDTO));
                    while (!future.isDone()) {
                        count = tableList.size();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    taskDebounce.put(key, false);
                }
                return this.getResponseData(String.valueOf(count));
            }
            return this.getResponseData(null, "\u6210\u529f", "\u6ca1\u6709\u8868\u6a21\u578b\u529f\u80fd\u53ef\u4ee5\u521b\u5efa");
        }
        int re = ((FnModelInfoService)this.getService()).insert((Object)inFnModelInfoDTO);
        if (re == 1) {
            try {
                boolean len = this.devtypeInfoExecService.create(inFnModelInfoDTO.getFnType1(), inFnModelInfoDTO.getFnType2(), userId, inFnModelInfoDTO.getFnId(), false, inFnModelInfoDTO.getParams());
            }
            catch (Exception e) {
                ((FnModelInfoService)this.getService()).deleteByPk((Object)inFnModelInfoDTO);
                throw e;
            }
        }
        return this.getResponseData(inFnModelInfoDTO.getFnId());
    }

    @PostMapping(value={"/api/fn/model/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="subsId") String subsId, @RequestParam(value="assemblySchemeId", required=false) String assemblySchemeId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="comId", required=false) String comId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestPart(value="file") MultipartFile file) {
        try {
            AppResourceItemListener listener = new AppResourceItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<FnModelInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    ((FnModelInfoService)this.getService()).deleteBySubsId(subsId);
                }
                ((FnModelInfoService)this.getService()).saveExcel(subsId, this.getUserInfo().getUserId(), assemblySchemeId, appId, comId, list);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u529f\u80fd\u70b9\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    @RequestMapping(value={"/client/FnModelInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody FnModelInfoDTO param) {
        return ((FnModelInfoService)this.getService()).deleteByCond(param);
    }

    @RequestMapping(value={"/api/fn/model/info/code"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryCodeWithSubsId(@RequestParam(value="subsId") String subsId, @RequestParam(value="fnType2", required=false) String fnType2) {
        String outputVo = ((FnModelInfoService)this.getService()).queryCodeWithPrefix(subsId, fnType2);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/FnModelInfoService/queryCodeWithPrefix"}, method={RequestMethod.POST})
    @ResponseBody
    public String queryCodeWithPrefix(@RequestParam(value="subsId") String subsId, @RequestParam(value="fnType2") String fnType2) {
        return ((FnModelInfoService)this.getService()).queryCodeWithPrefix(subsId, fnType2);
    }

    public static class CellItem {
        @ExcelProperty(value={"\u6a21\u5757"})
        private String moduleName;
        @ExcelProperty(value={"\u529f\u80fd\u7f16\u53f7"})
        private String fnCode;
        @ExcelProperty(value={"\u529f\u80fd\u540d\u79f0"})
        private String fnName;
        @ExcelProperty(value={"\u529f\u80fd\u5c42\u7ea7"})
        private Integer fnLevel;
        @ExcelProperty(value={"\u4e0a\u7ea7\u529f\u80fd"})
        private String fnAbvName;
        @ExcelProperty(value={"\u529f\u80fd\u5c0f\u7c7b"})
        private String fnType2;
        @ExcelProperty(value={"\u529f\u80fd\u63cf\u8ff0"})
        private String fnDesc;
        @ExcelProperty(value={"\u529f\u80fd\u6392\u5e8f"})
        private Integer fnOrder;
        @ExcelProperty(value={"\u529f\u80fd\u70b9\u89e6\u53d1\u65b9\u5f0f"})
        private String fnTrigger;
        @ExcelProperty(value={"\u5e94\u7528\u6807\u8bc6"})
        private String appId;
        @ExcelProperty(value={"\u5e94\u7528\u7b80\u79f0"})
        private String appCode;
        @ExcelProperty(value={"\u5e94\u7528\u540d\u79f0"})
        private String appName;

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getFnCode() {
            return this.fnCode;
        }

        public void setFnCode(String fnCode) {
            this.fnCode = fnCode;
        }

        public String getFnName() {
            return this.fnName;
        }

        public void setFnName(String fnName) {
            this.fnName = fnName;
        }

        public Integer getFnLevel() {
            return this.fnLevel;
        }

        public void setFnLevel(Integer fnLevel) {
            this.fnLevel = fnLevel;
        }

        public String getFnAbvName() {
            return this.fnAbvName;
        }

        public void setFnAbvName(String fnAbvName) {
            this.fnAbvName = fnAbvName;
        }

        public String getFnType() {
            return this.fnType2;
        }

        public void setFnType(String fnType2) {
            this.fnType2 = fnType2;
        }

        public String getFnDesc() {
            return this.fnDesc;
        }

        public void setFnDesc(String fnDesc) {
            this.fnDesc = fnDesc;
        }

        public Integer getFnOrder() {
            return this.fnOrder;
        }

        public void setFnOrder(Integer fnOrder) {
            this.fnOrder = fnOrder;
        }

        public String getFnTrigger() {
            return this.fnTrigger;
        }

        public void setFnTrigger(String fnTrigger) {
            this.fnTrigger = fnTrigger;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }

    public static class AppResourceItemListener
    extends AnalysisEventListener<CellItem> {
        private List<FnModelInfoDTO> list = new ArrayList<FnModelInfoDTO>();

        public List<FnModelInfoDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            FnModelInfoDTO vo = new FnModelInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }

    public class BatchGenerateFnTask
    implements Callable<ExecuteRtnInfo> {
        private List<ModelTableInfoDTO> sub;
        private FnModelInfoDTO inFnModelInfoDTO;
        private PaasAppsInfoDTO appInfo;

        public BatchGenerateFnTask(List<ModelTableInfoDTO> sub, FnModelInfoDTO inFnModelInfoDTO) {
            this.sub = sub;
            this.inFnModelInfoDTO = inFnModelInfoDTO;
        }

        @Override
        public ExecuteRtnInfo call() throws Exception {
            int count = 0;
            String now = CurrentDateUtil.getTodayDateEx2();
            String userId = this.inFnModelInfoDTO.getLoginUserId();
            String subsId = this.inFnModelInfoDTO.getSubsId();
            String appId = this.inFnModelInfoDTO.getAppId();
            String comId = this.inFnModelInfoDTO.getComId();
            String appCode = this.inFnModelInfoDTO.getAppCode();
            String appName = this.inFnModelInfoDTO.getAppName();
            String fnType1 = this.inFnModelInfoDTO.getFnType1();
            List fnTypes = this.inFnModelInfoDTO.getFnTypes();
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            FnModelInfoService fnModelInfoService = (FnModelInfoService)SpringContextUtils.getBean(FnModelInfoService.class);
            this.appInfo = new PaasAppsInfoDTO();
            this.appInfo.setAppId(appId);
            this.appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)this.appInfo);
            for (ModelTableInfoDTO table : this.sub) {
                for (String fnType2 : fnTypes) {
                    FnType fnTypeEnum = FnType.get((String)fnType2);
                    FnTypeInfoDTO fnTypeDTO = new FnTypeInfoDTO();
                    fnTypeDTO.setFnType1(fnType1);
                    fnTypeDTO.setFnType2(fnType2);
                    fnTypeDTO = (FnTypeInfoDTO)FnModelInfoController.this.fnTypeInfoService.queryByPk((Object)fnTypeDTO);
                    if (fnTypeDTO == null) {
                        logger.warn("\u529f\u80fd\u5c0f\u7c7b {} \u672a\u6709\u914d\u7f6e");
                        continue;
                    }
                    FnModelInfoDTO fnConfig = new FnModelInfoDTO();
                    fnConfig.setFnType2(fnType2);
                    fnConfig.setSubsId(subsId);
                    fnConfig.setAppId(appId);
                    fnConfig.setTableModelId(table.getObjectId());
                    List checkList = fnModelInfoService.queryListByPage((Object)fnConfig);
                    if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                        fnConfig = (FnModelInfoDTO)checkList.get(0);
                    } else {
                        String fnCode = fnModelInfoService.queryCodeWithPrefix(subsId, fnType2);
                        fnConfig.setFnId(subsId + fnCode);
                        fnConfig.setFnCode(fnCode);
                    }
                    fnConfig.setFnName(table.getObjectName() + fnTypeDTO.getFnType2Name());
                    fnConfig.setComId(comId);
                    fnConfig.setAppCode(appCode);
                    fnConfig.setAppName(appName);
                    fnConfig.setLoginUserId(userId);
                    fnConfig.setCreateUser(userId);
                    fnConfig.setCreateTime(now);
                    fnConfig.setUpdateUser(userId);
                    fnConfig.setUpdateTime(now);
                    fnConfig.setTemplateId(this.inFnModelInfoDTO.getTemplateId());
                    fnConfig.setTemplateName(this.inFnModelInfoDTO.getTemplateName());
                    fnConfig.setTableModelCode(table.getObjectCode());
                    fnConfig.setTableModelName(table.getObjectName());
                    fnConfig.setFnDesc(table.getObjectName() + fnTypeDTO.getFnType2Name());
                    fnConfig.setFnType2Name(fnTypeDTO.getFnType2Name());
                    fnConfig.setFnType1(fnTypeDTO.getFnType1());
                    fnConfig.setFnType1Name(fnTypeDTO.getFnType1Name());
                    int re = 0;
                    boolean reCreateFlag = false;
                    if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                        reCreateFlag = true;
                        re = fnModelInfoService.updateByPk((Object)fnConfig);
                    } else {
                        re = fnModelInfoService.insert((Object)fnConfig);
                    }
                    if (re != 1) continue;
                    ++count;
                    boolean flag = FnModelInfoController.this.devtypeInfoExecService.create(fnTypeDTO.getFnType1(), fnType2, userId, fnConfig.getFnId(), reCreateFlag, this.inFnModelInfoDTO.getParams());
                    if (flag) continue;
                    fnModelInfoService.deleteByPk((Object)fnConfig);
                }
            }
            return null;
        }
    }
}

