/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.SamCategoryInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.SamCategoryInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SamCategoryInfoController
extends BaseController<SamCategoryInfoDTO, SamCategoryInfoService> {
    @RequestMapping(value={"/api/sam/category/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SamCategoryInfoDTO>> querySamCategoryInfoAll(SamCategoryInfoDTO dto) {
        List outputVo = ((SamCategoryInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sam/category/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SamCategoryInfoDTO>> queryList(SamCategoryInfoDTO dto) {
        List outputVo = ((SamCategoryInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sam/category/info/{categoryId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SamCategoryInfoDTO> queryByPk(@PathVariable(value="categoryId") String categoryId) {
        SamCategoryInfoDTO inVo = new SamCategoryInfoDTO();
        inVo.setCategoryId(categoryId);
        SamCategoryInfoDTO outputVo = (SamCategoryInfoDTO)((SamCategoryInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sam/category/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SamCategoryInfoDTO inSamCategoryInfoDTO) {
        int outputVo = ((SamCategoryInfoService)this.getService()).deleteByPk((Object)inSamCategoryInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sam/category/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SamCategoryInfoDTO inSamCategoryInfoDTO) {
        this.setUserInfoToVO(inSamCategoryInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSamCategoryInfoDTO.setLastModifyUser(userId);
        inSamCategoryInfoDTO.setLastModifyTime(now);
        int outputVo = ((SamCategoryInfoService)this.getService()).updateByPk((Object)inSamCategoryInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sam/category/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSamCategoryInfo(@RequestBody SamCategoryInfoDTO inSamCategoryInfoDTO) {
        this.setUserInfoToVO(inSamCategoryInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSamCategoryInfoDTO.setCreateUser(userId);
        inSamCategoryInfoDTO.setCreateTime(now);
        inSamCategoryInfoDTO.setLastModifyUser(userId);
        inSamCategoryInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inSamCategoryInfoDTO.getCategoryId())) {
            inSamCategoryInfoDTO.setCategoryId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((SamCategoryInfoService)this.getService()).insert((Object)inSamCategoryInfoDTO);
        return this.getResponseData(outputVo);
    }
}

