/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.wiki.console.web.controller.api;

import com.irdstudio.allinrdm.wiki.console.facade.WikiBaseInfoService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiBaseInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class WikiBaseInfoController
extends BaseController<WikiBaseInfoDTO, WikiBaseInfoService> {
    @RequestMapping(value={"/api/wiki/base/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<WikiBaseInfoDTO>> queryWikiBaseInfoAll(WikiBaseInfoDTO dto) {
        this.setUserInfoToVO(dto);
        List outputVo = ((WikiBaseInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/base/info/{wikiId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<WikiBaseInfoDTO> queryByPk(@PathVariable(value="wikiId") String wikiId) {
        WikiBaseInfoDTO inVo = new WikiBaseInfoDTO();
        inVo.setWikiId(wikiId);
        WikiBaseInfoDTO outputVo = (WikiBaseInfoDTO)((WikiBaseInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody WikiBaseInfoDTO inWikiBaseInfoDTO) {
        this.setUserInfoToVO(inWikiBaseInfoDTO);
        int outputVo = ((WikiBaseInfoService)this.getService()).deleteByPk((Object)inWikiBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody WikiBaseInfoDTO inWikiBaseInfoDTO) {
        this.setUserInfoToVO(inWikiBaseInfoDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = inWikiBaseInfoDTO.getLoginUserId();
        inWikiBaseInfoDTO.setLastModifyUser(userId);
        inWikiBaseInfoDTO.setLastModifyTime(now);
        int outputVo = ((WikiBaseInfoService)this.getService()).updateByPk((Object)inWikiBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertWikiBaseInfo(@RequestBody WikiBaseInfoDTO inWikiBaseInfoDTO) {
        this.setUserInfoToVO(inWikiBaseInfoDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = inWikiBaseInfoDTO.getLoginUserId();
        inWikiBaseInfoDTO.setCreateUser(userId);
        inWikiBaseInfoDTO.setCreateTime(now);
        inWikiBaseInfoDTO.setLastModifyUser(userId);
        inWikiBaseInfoDTO.setLastModifyTime(now);
        int outputVo = ((WikiBaseInfoService)this.getService()).insert((Object)inWikiBaseInfoDTO);
        return this.getResponseData(outputVo);
    }
}

