/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.admin.facade.client.filter;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.allintcp.sdk.admin.facade.client.session.SessionManager;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.AuthInfoVO;
import com.irdstudio.sdk.beans.core.util.CookiesUtil;
import com.irdstudio.sdk.beans.core.util.MD5Util;
import com.irdstudio.sdk.beans.core.util.URLUtil;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SecurityPrincipalFilter
implements Filter {
    private SessionManager sessionManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.sessionManager = (SessionManager)applicationcontext.getBean("sessionManager", SessionManager.class);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String userId = principal.getName();
            AuthInfoVO authInfo = new AuthInfoVO();
            long timestamp = System.currentTimeMillis();
            UserInfo userInfo = new UserInfo();
            userInfo.setUserId(userId);
            userInfo.setUserName(userId);
            String jsonStr = JSONObject.toJSONString((Object)userInfo);
            String md5 = MD5Util.getMD5ofStr((String)URLUtil.md5((String)jsonStr, (Long)timestamp, (String)"123456"));
            authInfo.setUsercode(userId);
            String sessionId = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssoclient");
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                sessionId = request.getSession().getId();
            }
            authInfo.setSessionId(sessionId);
            authInfo.setTimestamp(timestamp);
            authInfo.setMd5(md5);
            authInfo.setUserInfo(userInfo);
            this.sessionManager.setLoginInfo(authInfo.getUserInfo(), request);
            this.sessionManager.setLoginInfo(sessionId, authInfo.getUserInfo(), request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

