/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.admin.web.operation;

import com.irdstudio.allintcp.sdk.admin.facade.client.filter.E4AJWTTokenFilter;
import com.irdstudio.allintcp.sdk.admin.facade.client.session.SessionManager;
import com.irdstudio.allintcp.sdk.admin.facade.operation.E4AService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.AuthInfoVO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SMenuFuncOpUserVO;
import com.irdstudio.allintcp.sdk.admin.web.ssm.util.TreeNodeUtil;
import com.irdstudio.sdk.beans.core.util.CookiesUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.core.vo.ZTreeVO;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class E4AController
extends AbstractController {
    private static Logger logger = LoggerFactory.getLogger(E4AController.class);
    @Autowired
    private E4AService e4aServiceC;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/api/oauth/token/jwt"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> authTokenByJWT(@RequestBody AuthInfoVO authInfoVO) {
        authInfoVO.setSessionId(this.httpRequest.getSession().getId());
        AuthInfoVO authInfo = this.e4aServiceC.login(authInfoVO);
        if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
            HashMap<String, String> tokenPayload = new HashMap<String, String>();
            tokenPayload.put("sessionId", authInfoVO.getSessionId());
            tokenPayload.put("signUserId", authInfo.getUsercode());
            tokenPayload.put("ssottp", String.valueOf(authInfo.getTimestamp()));
            tokenPayload.put("ssoclient", authInfo.getSessionId());
            tokenPayload.put("ssomd5", authInfo.getMd5());
            String token = E4AJWTTokenFilter.genJwtToken(tokenPayload);
            this.sessionManager.setLoginInfo(authInfo.getUserInfo(), this.httpRequest);
            return this.getResponseData(token);
        }
        ResponseData data = this.getResponseData(null);
        data.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\u6216\u7528\u6237\u5df2\u88ab\u6ce8\u9500");
        return data;
    }

    @RequestMapping(value={"/api/oauth/token/jwt/verify"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> verifyJwtToken(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Map tokenPayload = E4AJWTTokenFilter.verifyJwtToken((String)token);
            if (tokenPayload == null) {
                return this.getResponseData(false);
            }
            return this.getResponseData(true);
        }
        return this.getResponseData(false);
    }

    @RequestMapping(value={"/api/oauth/token"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> authToken(@RequestBody AuthInfoVO authInfoVO) {
        authInfoVO.setSessionId(this.httpRequest.getSession().getId());
        AuthInfoVO authInfo = this.e4aServiceC.login(authInfoVO);
        if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
            CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"ssoclient", (String)authInfo.getSessionId(), (int)-1);
            CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"ssottp", (String)String.valueOf(authInfo.getTimestamp()), (int)-1);
            CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"ssomd5", (String)authInfo.getMd5(), (int)-1);
            CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"signUserId", (String)authInfo.getUsercode(), (int)-1);
            this.sessionManager.setLoginInfo(authInfo.getUserInfo(), this.httpRequest);
            return this.getResponseData(true);
        }
        ResponseData data = this.getResponseData(false);
        data.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\u6216\u7528\u6237\u5df2\u88ab\u6ce8\u9500");
        return data;
    }

    @RequestMapping(value={"/api/session/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<UserInfo> getSessionInfo() {
        ResponseData data = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            data = this.getResponseData(userInfo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6session\u767b\u5f55\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
            this.httpResponse.setStatus(401);
        }
        return data;
    }

    @RequestMapping(value={"/api/logout"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> logout() {
        ResponseData data = null;
        try {
            Cookie[] cookies;
            String sessionId = CookiesUtil.getCookieValue((HttpServletRequest)this.httpRequest, (String)"ssoclient");
            for (Cookie c : cookies = this.httpRequest.getCookies()) {
                if (!"ssoclient".equals(c.getName()) && !"ssottp".equals(c.getName()) && !"ssomd5".equals(c.getName())) continue;
                c.setMaxAge(0);
                this.httpResponse.addCookie(c);
            }
            this.sessionManager.removeSession(sessionId);
            logger.info("\u6e05\u7a7asession");
            data = this.getResponseData(true);
        }
        catch (Exception e) {
            logger.error("\u767b\u51fa\u5931\u8d25" + e.getMessage(), (Throwable)e);
            data = this.getResponseData(false);
            data.setMessage("\u767b\u51fa\u5931\u8d25!");
        }
        return data;
    }

    @RequestMapping(value={"/api/account/modifyUserPwd"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> changePasswrod(@RequestBody AuthInfoVO authInfoVO) {
        ResponseData data = null;
        UserInfo userInfo = this.getUserInfo();
        authInfoVO.setUsercode(userInfo.getUserId());
        AuthInfoVO resultInfo = this.e4aServiceC.modifyUserPassword(authInfoVO);
        if (resultInfo != null) {
            if (resultInfo.isChangeSuccess()) {
                data = this.getResponseData(true);
            } else {
                data = this.getResponseData(false);
                data.setMessage(resultInfo.getMessage());
            }
        } else {
            data = this.getResponseData(false);
        }
        return data;
    }

    @RequestMapping(value={"/api/admin/menus"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<SMenuFuncOpUserVO> menuAndFuncOp() {
        SMenuFuncOpUserVO output = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            if (Objects.nonNull(userInfo)) {
                output = this.e4aServiceC.queryUserResourceInfo(userInfo.getUserId());
                output.setActorNo(userInfo.getUserId());
                output.setActorName(userInfo.getUserName());
                this.sessionManager.setUserResource(output, this.httpRequest);
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5b50\u7cfb\u7edf\u83dc\u5355\u8d44\u6e90\u53ca\u83dc\u5355\u64cd\u4f5c\u6743\u9650\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/esaas/menus"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<SMenuFuncOpUserVO> esaasAppMenuAndFuncOp() {
        SMenuFuncOpUserVO output = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            if (Objects.nonNull(userInfo)) {
                output = this.e4aServiceC.queryEsaasAppUserMenus(userInfo.getUserId(), userInfo.getAllowopersys());
                output.setActorNo(userInfo.getUserId());
                output.setActorName(userInfo.getUserName());
                this.sessionManager.setUserResource(output, this.httpRequest);
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u7cfb\u7edf\u83dc\u5355\u8d44\u6e90\u53ca\u83dc\u5355\u64cd\u4f5c\u6743\u9650\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/s/menu/user/{resourceId}/{actorNo}/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ZTreeVO> getSResourceTree(@PathVariable(value="resourceId") String resourceId, @PathVariable(value="actorNo") String actorNo, @PathVariable(value="subsId") String subsId) {
        ArrayList<ZTreeVO> sResourceTreeList;
        ArrayList<ZTreeVO> outputVo = new ArrayList<ZTreeVO>();
        List menusUser = (List)this.httpRequest.getSession().getAttribute(actorNo);
        if (Objects.nonNull(menusUser) && menusUser.size() > 0 && Objects.nonNull(sResourceTreeList = TreeNodeUtil.getSResourceTree(menusUser, subsId)) && sResourceTreeList.size() > 0) {
            for (ZTreeVO sResourceTree : sResourceTreeList) {
                if (!sResourceTree.getId().equals(resourceId)) continue;
                outputVo.add(sResourceTree);
            }
        }
        return outputVo;
    }
}

