/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.card.manual.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintcp.sdk.card.facade.operation.CardBaseInfoService;
import com.irdstudio.allintcp.sdk.card.facade.operation.CardPageInfoService;
import com.irdstudio.allintcp.sdk.card.facade.operation.CardPageLayoutService;
import com.irdstudio.allintcp.sdk.card.facade.operation.dto.CardBaseInfoDTO;
import com.irdstudio.allintcp.sdk.card.facade.operation.dto.CardPageInfoDTO;
import com.irdstudio.allintcp.sdk.card.facade.operation.dto.CardPageLayoutDTO;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AutoLoadPageDataServiceImpl
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoLoadPageDataServiceImpl.class);
    @Autowired
    protected CardPageInfoService cardPageInfoService;
    @Autowired
    protected CardPageLayoutService cardPageLayoutService;
    @Autowired
    protected CardBaseInfoService cardBaseInfoService;

    public void afterPropertiesSet() {
        try {
            Resource[] jsonResources;
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (Resource json : jsonResources = pathMatchingResourcePatternResolver.getResources("classpath*:META-INF/card/*.json")) {
                try {
                    CardPageInfoDTO checkObj;
                    String jsonString = IOUtils.toString((InputStream)json.getInputStream(), (String)"UTF-8");
                    CardPageData data = (CardPageData)JSON.parseObject((String)jsonString, CardPageData.class);
                    if (data == null || (checkObj = this.cardPageInfoService.queryByPk(data.getPageInfo())) != null) continue;
                    this.cardPageInfoService.insert((Object)data.getPageInfo());
                    this.cardPageLayoutService.batchInsert(data.getPageLayout());
                    this.cardBaseInfoService.batchInsert(data.getCard());
                }
                catch (Exception e) {
                    logger.error("\u52a0\u8f7d\u9875\u9762\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u9875\u9762\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static class CardPageData {
        private CardPageInfoDTO pageInfo;
        private List<CardPageLayoutDTO> pageLayout;
        private List<CardBaseInfoDTO> card;

        public CardPageInfoDTO getPageInfo() {
            return this.pageInfo;
        }

        public void setPageInfo(CardPageInfoDTO pageInfo) {
            this.pageInfo = pageInfo;
        }

        public List<CardPageLayoutDTO> getPageLayout() {
            return this.pageLayout;
        }

        public void setPageLayout(List<CardPageLayoutDTO> pageLayout) {
            this.pageLayout = pageLayout;
        }

        public List<CardBaseInfoDTO> getCard() {
            return this.card;
        }

        public void setCard(List<CardBaseInfoDTO> card) {
            this.card = card;
        }
    }
}

