/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.card.autoconfigure;

import com.irdstudio.allintcp.sdk.card.manual.application.operation.AutoLoadPageDataServiceImpl;
import com.irdstudio.allintcp.sdk.card.manual.application.operation.CardServiceImpl;
import com.irdstudio.allintcp.sdk.card.manual.facade.operation.CardService;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.irdstudio.allintcp.sdk.card"})
public class AllintpaasSdkCardAutoConfiguration {
    @Bean
    public MapperScannerConfigurer allintcpSdkCardMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintcp.sdk.card.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils utils = new SpringContextUtils();
        utils.setApplicationContext(ctx);
        return utils;
    }

    @Bean
    @ConditionalOnMissingBean(value={CardService.class})
    public CardService cardService(SqlSessionFactory sqlSessionFactory) {
        CardServiceImpl cardService = new CardServiceImpl();
        cardService.setSqlSessionFactory(sqlSessionFactory);
        return cardService;
    }

    @Bean
    @ConditionalOnProperty(value={"allintcp.sdk.card.load.data.disabled"}, matchIfMissing=true)
    public AutoLoadPageDataServiceImpl autoLoadPageDataService() {
        AutoLoadPageDataServiceImpl service = new AutoLoadPageDataServiceImpl();
        return service;
    }

    @ConditionalOnMissingBean(type={"com.irdstudio.allintcp.sdk.bi.autoconfigure.AllintpaasSdkBiAutoConfiguration.AllintpaasSdkBiMvcConfig"})
    @Configuration
    @EnableWebMvc
    public class AllintpaasSdkCardMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

