(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 指标模型选择
    exports.IndModelInfoListStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                dgUrl: window.contextPath + 'api/IndModelInfo/queryList',
                signUserId: signUserId,
                queryParams: {
                    "IndCategory": 'S',
                    "IndId": "",
                    "IndName": "",
                    "IndType": "",
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            doView(row){
                const self = this
                ElementDialog.createDialog(`查看`,`${contextPath}page/allintcp/sdk/index/IndModelInfoView.html?modelType=${row.modelType}&IndId=${row.IndId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList  && !initFlag) {
                    this.queryList()
                }
            },
            handlerDblclick(row) {
                this.handlerTableCurrentChange(row);
                this.submitForm()
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            submitForm() {
                if (this.currentRow) {
                    this.$emit('next', Vue.unref(this.currentRow))
                } else {
                    ElementPlus.ElMessage({
                        showClose: true,
                        message: '请选择一条记录！',
                        type: 'warning',
                    })
                }
            }
        },
        computed:{
            breadcrumb() {
                return `指标模型列表`
            },

            DIC() {
                return {
                    GROUP_IND_TYPE: [
                        {'enname': '', 'cnname': '全部'},
                        { 'enname': 'D', 'cnname': '日指标' },
                        { 'enname': 'M', 'cnname': '月指标' },
                        { 'enname': 'S', 'cnname': '季指标' },
                        { 'enname': 'W', 'cnname': '周指标' },
                        { 'enname': 'Y', 'cnname': '年指标' },
                    ],

                    IND_CATEGORY: [
                        { 'enname': 'F', 'cnname': '固定指标' },
                        { 'enname': 'S', 'cnname': '订阅指标' },
                    ],
                    IND_TYPE: [
                        { 'enname': 'D', 'cnname': '日指标' },
                        { 'enname': 'M', 'cnname': '月指标' },
                        { 'enname': 'S', 'cnname': '季指标' },
                        { 'enname': 'W', 'cnname': '周指标' },
                        { 'enname': 'Y', 'cnname': '年指标' },
                    ],
                    IND_CLEAN_TYPE: [
                        { 'enname': '01', 'cnname': '不清理' },
                        { 'enname': '02', 'cnname': '保留30天' },
                        { 'enname': '03', 'cnname': '保留90天' },
                        { 'enname': '04', 'cnname': '保留180天' },
                    ],
                    IND_MODEL_TYPE: [
                        { 'enname': 'C', 'cnname': '指标卡' },
                        { 'enname': 'T', 'cnname': '指标表' },
                    ],
                }
            },
            filterConfig() {
                const { prefix } = this;
                return [
                    { key: 'appCode', name: '所属应用简称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'appName', name: '所属应用名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'comFullName', name: '所属组件全称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'indCleanType', name: prefix + '数据清理机制', type: 'select', opType: this.DIC.IND_CLEAN_TYPE, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0), },
                    { key: 'indId', name: prefix + '标识', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'indCode', name: prefix + '代码', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'indName', name: prefix + '名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'tableModelCode', name: prefix + '数据表代码', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'tableModelName', name: prefix + '数据表名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                ]
            },
            sortConfig() {
                const { prefix } = this;
                return [
                    {label: `按${prefix}编号顺序`, key: 'indId', type: 'asc'},
                    {label: `按${prefix}编号倒序`, key: 'indId', type: 'desc'},
                    {label: `按${prefix}排序顺序`, key: 'orderValue', type: 'asc'},
                    {label: `按${prefix}排序倒序`, key: 'orderValue', type: 'desc'},
                ]
            },
            groupConfig() {
                return [
                    {
                        id: 1,
                        label: '按指标类型',
                        key: 'IndType',
                        dgUrl: this.dgUrl,
                        queryParams: this.queryParams,
                        queryParamsHandler: this.queryParamsHandler,
                        change: this.allSearch,
                        opType: this.DIC.GROUP_IND_TYPE,
                    },
                ]
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
            prefix() {
                return  '指标'
            }
        },
        mounted() {
            const self = this;
            self.groupItem = self.groupConfig[0];
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                    <group-dropdown v-model="groupItem" :group-config="groupConfig"></group-dropdown>
                    <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             enable-search
                             :all-items="[]"
                             @all-search="allSearch"
                >
                    <template #more>
                        <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                            <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                            <el-row v-if="groupItem">
                                <el-col :span="24">
                                    <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </template>
                </page-search>
                <template v-if="listView">
                    <el-table :data="tableData"
                              v-loading="loading"
                              stripe border
                              highlight-current-row
                              @current-change="handlerTableCurrentChange" @row-dblclick="handlerDblclick"
                              tooltip-effect="light"
                              :tooltip-options="{placement : 'bottom'}"
                              style="width: 100%" >
                        <el-table-column type="index" width="45" ></el-table-column>
                        <el-table-column resizable prop="indId" :label="prefix + '标识'"  show-overflow-tooltip   >
                            <template #default="{row, $index}">
                                <el-link type="primary" :underline="false" @click="indIdColHandler(row)">{{row.indId}}</el-link>
                            </template>
                        </el-table-column>
                        <el-table-column resizable prop="indCode" :label="prefix + '代码'"  show-overflow-tooltip   >
                        </el-table-column>
                        <el-table-column resizable prop="indName" :label="prefix + '名称'"  show-overflow-tooltip   >
                        </el-table-column>
                        <el-table-column resizable prop="indCategory" :label="prefix + '类别'"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('IND_CATEGORY', value)" >
                        </el-table-column>
                        <el-table-column resizable prop="indType" :label="prefix + '类型'"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('IND_TYPE', value)" >
                        </el-table-column>
                        <el-table-column resizable prop="indCleanType" :label="prefix + '数据清理机制'"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('IND_CLEAN_TYPE', value)" >
                        </el-table-column>
                    </el-table>
                    <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                </template>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));