/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.job.application.operation;

import com.irdstudio.allintcp.sdk.job.facade.operation.dto.JobExecuteParamDTO;
import com.irdstudio.framework.beans.core.base.FrameworkService;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;

public abstract class JobAbstractServiceImpl
extends SqlSessionDaoSupport
implements FrameworkService {
    public static Logger logger = LoggerFactory.getLogger(JobAbstractServiceImpl.class);
    private ApplicationContext applicationContext;

    public void initDao() throws Exception {
        super.initDao();
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.applicationContext.getBean(SqlSessionFactory.class);
        this.setSqlSessionFactory(sqlSessionFactory);
    }

    public String getMapperId(String jobId, String jobSql) {
        return jobId + "Mapper." + jobId + jobSql;
    }

    public int executeSqlByJobId(String jobId, String jobSql, JobExecuteParamDTO params) {
        return this.getSqlSession().update(this.getMapperId(jobId, jobSql), (Object)params);
    }

    public void initService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        try {
            this.initDao();
        }
        catch (Exception e) {
            throw new ApplicationContextException(e.getMessage(), (Throwable)e);
        }
    }
}

