/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.schedule.application.schedule;

import com.irdstudio.allintcp.sdk.schedule.application.schedule.QuartzJobEngine;
import com.irdstudio.allintcp.sdk.schedule.application.schedule.QuartzManager;
import com.irdstudio.allintcp.sdk.schedule.facade.operation.SSrvsCronConfService;
import com.irdstudio.allintcp.sdk.schedule.facade.operation.dto.SSrvsCronConfDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleJobUtil {
    public static final String STATE_WAIT = "S";
    public static final String STATE_ARRANGED = "A";
    public static final String STATE_RUNNING = "R";
    public static final String STATE_FALSE = "F";
    private static Logger logger = LoggerFactory.getLogger(ScheduleJobUtil.class);
    public static String JOB_GROUP_NAME = "AGENT_JOB_GROUP";
    public static String TRIGGER_NAME = "AGENT_TRIGGER";
    public static String TRIGGER_GROUP_NAME = "AGENT_TRIGGER_GROUP";

    public static void loadJobsForExecutor() {
        logger.info("\u5f00\u59cb\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        try {
            SSrvsCronConfService sSrvsCronConfService = (SSrvsCronConfService)SpringContextUtils.getBean(SSrvsCronConfService.class);
            SSrvsCronConfDTO param = new SSrvsCronConfDTO();
            List cronConfList = sSrvsCronConfService.queryList((Object)param);
            for (SSrvsCronConfDTO cronConf : cronConfList) {
                if (cronConf.getJobState().equals(STATE_WAIT)) {
                    cronConf.setJobState(STATE_ARRANGED);
                    sSrvsCronConfService.updateByPk((Object)cronConf);
                }
                logger.info("\u52a0\u5165\u5b9a\u65f6\u4efb\u52a1\uff1a" + cronConf.getJobDesc() + "...");
                QuartzManager.addJob(cronConf.getJobCode(), JOB_GROUP_NAME, TRIGGER_NAME + "-" + cronConf.getJobCode(), TRIGGER_GROUP_NAME, QuartzJobEngine.class, cronConf.getCronExpression());
            }
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        logger.info("\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }

    public static void stopJobsForAgent() {
        logger.info("\u5f00\u59cb\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        try {
            QuartzManager.shutdownJobs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }
}

