/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.schedule.autoconfigure;

import com.irdstudio.allintcp.sdk.schedule.application.schedule.ActiveCronConfConfiguration;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnMissingBean(name={"activeCronConfConfiguration"})
@ComponentScan(value={"com.irdstudio.allintcp.sdk.schedule"})
public class SdkScheduleAutoConfiguration {
    @Bean
    public MapperScannerConfigurer scheduleMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintcp.sdk.schedule.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils() {
        return new SpringContextUtils();
    }

    @Bean
    @ConditionalOnExpression(value="'${allintcp.sdk.schedule.cron.disabled}'!='true'")
    public ActiveCronConfConfiguration activeCronConfConfiguration() {
        ActiveCronConfConfiguration activeCronConfConfiguration = new ActiveCronConfConfiguration();
        activeCronConfConfiguration.activeConsoleExecutor();
        return activeCronConfConfiguration;
    }

    @Configuration
    @EnableWebMvc
    public class ScheduleMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

