/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.sequence.autoconfigure;

import com.irdstudio.allintcp.sdk.sequence.web.operation.SeqInstInfoController;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={SeqInstInfoController.class})
@ComponentScan(value={"com.irdstudio.allintcp.sdk.sequence"})
public class SdkSequenceAutoConfiguration {
    @Bean
    public MapperScannerConfigurer seqMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintcp.sdk.sequence.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils utils = new SpringContextUtils();
        utils.setApplicationContext(ctx);
        return utils;
    }

    @Configuration
    @EnableWebMvc
    public class SeqMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

