(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 执行流水线日志
    exports.BatInstBatchLog = {
        props: ['batchId', 'batchName', 'batchSerialNo'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                loading: false,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryList() {
                const self = this;
                self.loading = true;
                setTimeout(function() {
                    self.loading = false;
                }, 50)
            },
            closeForm() {
                this.$emit('close')
            },
        },
        watch: {
            "batchSerialNo": function(val) {
                this.queryList()
            }
        },
        computed:{
            breadcrumb() {
                return '流水线日志'
            },

            DIC() {
                return {
                }
            },
            url() {
                return `../../../../page/allintpaas/batch/console/BatchMonitorIframe.html?batchSerialNo=${this.batchSerialNo}&batchId=${this.batchId}`
            }
        },
        mounted() {
            const self = this;

            self.queryList()
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24" v-loading="loading" element-loading-text="正在执行流水线..." :style="{ height: windowHeight.value - 150 }">
                <iframe v-if="!loading" scrolling="auto" frameborder="0" :src="url" style="width:100%;height:100%;"></iframe>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `
    }

}));