(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 流水线可视化编辑
    exports.BatInstBatchVs = {
        props: ['batchId', 'batchName', 'batchSerialNo'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                signUserId: signUserId,
                loading: false,

                stageList: [],

                _refreshInst: undefined,
            }
        },
        watch: {
            batchId(val) {
                this.queryParams.batchId = val
                this.autoRefresh()
            },
        },
        methods: {
            autoRefresh() {
                const self = this;
                self.queryList();
                var batchState="";
                $.restfulPostJson('../../../../api/BatInstBatch/queryByPk',{ batchSerialNo : self.batchSerialNo },function(data){
                    batchState=data.rows.batchState;
                    if (batchState == '3' || batchState=='8'){
                        self._refreshInst = setTimeout(self.autoRefresh, 3 * 1000)
                    } else {
                        if (self._refreshInst) {
                            clearTimeout(self._refreshInst)
                            self._refreshInst = undefined;
                        }
                    }
                }, function(e){}, true);

            },
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            formatterStageStatus(stage) {
                let status = ''
                if (stage.taskList) {
                    if (stage.taskList.findIndex(task=>task.taskRunState == '7') >= 0) {
                        status = 'error'
                    } else if (stage.taskList.findIndex(task=> ['4', '3', '2'].indexOf(task.taskRunState) >= 0 ) >= 0) {
                        status = 'process'
                    } else if (stage.taskList.filter( task=> ['6'].indexOf(task.taskRunState) >= 0 ).length == stage.taskList.length ) {
                        status = 'success'
                    } else if (stage.taskList.filter( task=> ['0', '1'].indexOf(task.taskRunState) >= 0 ).length == stage.taskList.length ) {
                        status = 'wait'
                    } else {
                        status = 'finish'
                    }
                }
                return status;
            },
            formatterTaskStatus(task) {
                let status = ''
                if (task) {
                    if (task.taskRunState == '7') {
                        status = 'error'
                    } else if (['4', '3', '2'].indexOf(task.taskRunState) >= 0) {
                        status = 'process'
                    } else if (['6'].indexOf(task.taskRunState) >= 0 ) {
                        status = 'success'
                    } else if (['0', '1'].indexOf(task.taskRunState) >= 0 ) {
                        status = 'wait'
                    } else {
                        status = 'finish'
                    }
                }
                return status;
            },
            handlerTableCurrentChange(row) {
                // this.currentRow = row;
            },
            queryList() {
                const self = this;
                self.loading = true;

                // 阶段列表
                $.restfulPostJson('../../../../api/BatBatchStageConfig/queryList', { batchId: this.batchId, size: 1000 }, function(data){
                    self.stageList = data.rows;
                    //任务列表
                    $.restfulPostJson('../../../../api/BatInstTask/queryList', { batchId: this.batchId, batchSerialNo: this.batchSerialNo , size: 1000 }, function(data){
                        const taskList = data.rows;
                        self.stageList.forEach(function(stage){
                            stage.taskList = taskList.filter(function(task){
                                return task.stageId == stage.stageId
                            })
                            // stage.taskList = JSON.parse(JSON.stringify(taskList))
                        })
                        self.loading = false;
                    }, function(){ self.loading = false; }, true);
                }, function(){ self.loading = false; }, true);

            },
            reloadList() {
                this.queryList();
                
            },
            doView(row) {
                const self = this
                window.top.reloadList = self.reloadList
                window._alreadyBind = true
                ElementDialog.createDialog(row.taskName + '详情', '../../../../page/allintpaas/batch/console/BatTaskUnitConfigView.html?' + 'taskId=' + row.taskId);
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.autoRefresh();
            },
        },
        computed:{
            DIC() {
                return {

                }
            },
            breadcrumb() {
                return [ '流水线监控']
            },
        },
        mounted() {
            const self = this;
            self.autoRefresh();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24" :style="{ height: windowHeight.value - 200 }">
                <el-steps   align-center class="bat-steps">
                    <el-step v-for="(stage, index) in stageList" :key="index" :title="stage.stageName" :status="formatterStageStatus(stage)">
                        <template  #description>
                            <div class="bat-tasks" >
                                <div class="bat-task" v-for="(task, tIndex) in stage.taskList" @dblclick.prevent="doView(task)" :class="[ 'is-' + formatterTaskStatus(task) ]">
                                    <div class="bat-task-item">
                                        <div class="bat-task-icon"> <i class="iconfont icon-task"></i> </div>
                                        <div class="bat-task-text">{{ task.taskName }}</div>
                                    </div>
                                    <div class="bat-task-line" v-if="tIndex < stage.taskList.length - 1"> <i></i> </div>
                                </div>
                            </div>
                        </template>
                    </el-step>
                </el-steps>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `,
    }

}));