(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    
    exports.RPT000031Rpt = {
        props: {
            startDate: String,
            endDate: String,
        },
        inject: ['DIC', 'searchParams', 'windowHeight', 'windowWidth'],
        data(){
            return {
                // 卡片内容数据
                queryParams: {
                    
                },
                tableData: [],
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                filterCond: [],


                spacer : Vue.h(ElementPlus.ElDivider, { direction: 'vertical' }),

                width: '100%',
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            queryParamsHandler(params){
                const self = this;
                
                let localFilterCond = JSON.parse(JSON.stringify(this.filterCond)) || []
                // 添加报表周期条件
                localFilterCond.push({ "op":"btw","key":"batch_date","values": [self.startDate, self.endDate] })
                // 过滤条件
                if (localFilterCond && localFilterCond.length > 0) {
                    params.filterCond = JSON.stringify(localFilterCond)
                }
                params.startDate = self.startDate;
                params.endDate = self.endDate;
                return params
            },
            // 卡片内容函数
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.toRaw(self.pageInfo),
                    ...Vue.toRaw(self.queryParams)
                }
                params[self.allName] = self.all
                self.queryParamsHandler(params)
                // 不是列表周报不分页
                params.size = 1000;
                $.restfulPostJson(contextPath + 'api/rpt/query/RPT00003/1', params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.queryStateEcharts(self.tableData);
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            queryStateEcharts(rows) {
                const self = this;

                if (!window.echarts) {
                    setTimeout(function(){
                        self.queryStateEcharts(rows);
                    }, 200);
                    return ;
                }
                self.width = rows.length * 30 < self.windowWidth.value ? self.windowWidth.value : rows.length * 30
                const instance = echarts.init(document.getElementById('RPT000031'), null, {
                    width: self.width,
                    height: self.windowHeight.value - 100
                });
                instance.setOption(
                        {
                            tooltip: {
                                trigger: 'axis',
                                axisPointer: { type: 'cross' },
                                position: function (pos, params, el, elRect, size) {
                                    var obj = { top: 0, left: pos[0] + 10 };
                                    return obj;
                                },
                            },
                            legend: {
                                selectedMode: true,
                            },
                            grid : {
                                left: 100,
                                right: 100,
                                top: 50,
                                bottom: 50,
                                containLabel: true
                            },
                            xAxis: {
                                type: 'category',
                                data: rows.map(el=>el.batch_date),
                                axisLabel: {
                                    interval: 0,
                                }
                            },
                            yAxis: {
                                type: 'value'
                            },
                            series: [
                                {
                                    name: '运行时长',
                                    type: 'bar',
                                    barWidth: '20%',
                                    label: {
                                        show: true,
                                    },
                                    data: rows.map(r=>{
                                        return r.cost_time
                                    })
                                },
                            ]
                            
                            
                        }
                )
                self.$nextTick(()=>{
                    instance.resize({
                        width: self.width,
                        height: self.windowHeight.value - 100
                    });
                })
            },
        },
        computed:{
            DIC() {
                return {
                }
            },
            tabTitle() {
                return this.cardName
            },
        },
        mounted() {
            const self = this;

            loadjs([contextPath + "static/js/echarts.min.js"],{returnPromise: true});
        },
        unmounted() {

        },
        template: `
<el-col :span="24" >
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" breadcrumb="批次运行时长" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
    <div style="width: 100%; " :style="{ height: windowHeight.value - (hideHeader ? 0 : 100 ) }">
        <el-scrollbar>
            <div :style="{ width: width , height: 'auto' }">
                <div id="RPT000031" style="height: 600px; width: 100%; " ></div>
            </div>
        </el-scrollbar>
    </div>
    </el-card>
</el-col>
        `
    }


}));