(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 流水线可视化编辑
    exports.BatBatchVs = {
        props: ['batchId', 'batchName'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                signUserId: signUserId,
                loading: false,

                stageList: [],
            }
        },
        watch: {
            batchId(val) {
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                // this.currentRow = row;
            },
            queryList() {
                const self = this;
                self.loading = true;

                // 阶段列表
                $.restfulPostJson('../../../../api/BatBatchStageConfig/queryList', { batchId: this.batchId, size: 1000 }, function(data){
                    self.stageList = data.rows;
                    //任务列表
                    $.restfulPostJson('../../../../api/BatTaskUnitConfig/queryList', { batchId: this.batchId, size: 1000  }, function(data){
                        const taskList = data.rows;
                        self.stageList.forEach(function(stage){
                            stage.taskList = taskList.filter(function(task){
                                return task.stageId == stage.stageId
                            })
                            // stage.taskList = JSON.parse(JSON.stringify(taskList))
                        })
                        self.loading = false;
                    }, function(){ self.loading = false; }, true);
                }, function(){ self.loading = false; }, true);


            },
            reloadList() {
                this.queryList();
                
            },
            doAdd(stage) {
                const self = this
                window.top.reloadList = self.reloadList
                window._alreadyBind = true
                stage.taskList = stage.taskList || []
                let preTaskId = ''
                if (stage.taskList.length > 0) {
                    preTaskId = stage.taskList[stage.taskList.length - 1].taskId || `${this.batchId}-${stage.stageOrder}0`
                } else {
                    preTaskId = `${this.batchId}-${stage.stageOrder}0`
                }

                ElementDialog.createDialog('新增流水线任务', '../../../../page/allintpaas/batch/conf/BatTaskUnitConfigAdd.html?batchId='+this.batchId+"&stageId="+stage.stageId + '&preTaskId=' + preTaskId).then(self.queryList);
            },
            doUpdate(row) {
                const self = this
                window.top.reloadList = self.reloadList
                window._alreadyBind = true
                ElementDialog.createDialog(row.taskName + '修改', '../../../../page/allintpaas/batch/manual/BatTaskUnitConfigUpdate.html?' + 'taskId=' + row.taskId).then(self.queryList);
            },
            doDelete(row) {
                const self = this
                if (row) {
                    const param = Vue.unref(row);
                    self.currentRow = param;
                    ElementPlus.ElMessageBox.confirm(
                        `你确定要删除${row.taskName}(${row.taskId})?`,
                        '提示',
                        {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning',
                        }
                    ).then(() => {
                        $.restfulPostJson('../../../../api/BatTaskUnitConfig/deleteByPk', row, function(data) {
                            if (data.success) {
                                ElementPlus.ElMessage({
                                    showClose: true,
                                    message: '删除成功',
                                    type: 'success',
                                })
                                self.queryList();
                            }
                        });
                    })
                }
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
        },
        computed:{
            DIC() {
                return {
                    SOLUTION_TYPE: window.SOLUTION_TYPE || [],

                }
            },
            breadcrumb() {
                return [ `${this.batchName}` ,'流水线编辑']
            },
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24" :style="{ height: windowHeight.value - 250 }">
                <el-steps   align-center class="bat-steps">
                    <el-step v-for="(stage, index) in stageList" :key="index" :title="stage.stageName" status="finish">
                        <template  #description>
                            <div class="bat-tasks" >
                                <div v-if="!stage.taskList || stage.taskList.length == 0" style="margin-top: 10px;">
                                   <el-button @click="doAdd(stage)" type="default" circle  icon="Plus" size="small"></el-button>
                                </div>
                                <div class="bat-task" v-for="(task, tIndex) in stage.taskList" @dblclick.prevent="doUpdate(task)">
                                    <div class="bat-task-item">
                                        <div class="bat-task-icon"> <i class="iconfont icon-task"></i> </div>
                                        <div class="bat-task-text">{{ task.taskName }}</div>
                                    </div>
                                    <div class="bat-task-line" v-if="tIndex < stage.taskList.length - 1"> <i></i> </div>
                                    <div class="bat-task-btn"  v-if="tIndex == stage.taskList.length - 1">
                                           <el-button class="bat-task-add-el-button" @click="doAdd(stage)" type="default" circle  icon="Plus" size="small"></el-button>
                                    </div>
                                    <div class="bat-task-btn" >
                                           <el-button class="bat-task-del-el-button" @click="doDelete(task)" type="danger" circle  icon="CloseBold" size="small"></el-button>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </el-step>
                </el-steps>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `,
    }

}));