(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 流水线可视化编辑
    exports.BatBatchVs = {
        props: ['batchId', 'batchName'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                signUserId: signUserId,
                loading: false,

                stageList: [],
            }
        },
        watch: {
            batchId(val) {
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                // this.currentRow = row;
            },
            queryList() {
                const self = this;
                self.loading = true;

                // 阶段列表
                $.restfulPostJson(window.contextPath + 'api/BatBatchStageConfig/queryList', { batchId: this.batchId, size: 1000, ascOrder: 'stageOrder' }, function(data){
                    self.stageList = data.rows;
                    //任务列表
                    $.restfulPostJson(window.contextPath + 'api/BatTaskUnitConfig/queryList', { batchId: this.batchId, size: 1000  }, function(data){
                        const taskList = data.rows;
                        self.stageList.forEach(function(stage){
                            stage.taskList = taskList.filter(function(task){
                                return task.stageId == stage.stageId
                            })
                            // stage.taskList = JSON.parse(JSON.stringify(taskList))
                        })
                        self.loading = false;
                    }, function(){ self.loading = false; }, true);
                }, function(){ self.loading = false; }, true);


            },
            reloadList() {
                this.queryList();
                
            },
            doAdd(stage) {
                const self = this
                stage.taskList = stage.taskList || []
                let preTaskId = ''
                if (stage.taskList.length > 0) {
                    preTaskId = stage.taskList[stage.taskList.length - 1].taskId || `${this.batchId}-${stage.stageOrder}0`
                } else {
                    preTaskId = `${this.batchId}-${stage.stageOrder}0`
                }

                ElementDialog.createDialog('新增流水线任务', window.contextPath + 'page/allintpaas/batch/manual/BatTaskUnitConfigAdd.html?batchId='+this.batchId+"&stageId="+stage.stageId + '&preTaskId=' + preTaskId).then(self.queryList);
            },
            doUpdate(row) {
                const self = this
                ElementDialog.createDialog(row.taskName + '修改', window.contextPath + 'page/allintpaas/batch/manual/BatTaskUnitConfigUpdate.html?' + 'taskId=' + row.taskId).then(self.queryList);
            },
            doDelete(row) {
                const self = this
                if (row) {
                    const param = Vue.unref(row);
                    self.currentRow = param;
                    ElementPlus.ElMessageBox.confirm(
                        `你确定要删除${row.taskName}(${row.taskId})?`,
                        '提示',
                        {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning',
                        }
                    ).then(() => {
                        $.restfulPostJson(window.contextPath + 'api/BatTaskUnitConfig/deleteByPk', row, function(data) {
                            if (data.success) {
                                ElementPlus.ElMessage({
                                    showClose: true,
                                    message: '删除成功',
                                    type: 'success',
                                })
                                self.queryList();
                            }
                        });
                    })
                }
            },


            doStageAdd(row) {
                const self = this
                const index = self.stageList.findIndex(el=>el.stageId === row.stageId)
                ElementDialog.createDialog('新增流水线阶段', window.contextPath + 'page/allintpaas/batch/manual/BatBatchStageConfigAdd.html?batchId=' + this.batchId + '&stageOrder=' + index ).then(self.queryList);
            },
            doStageUpdate(row) {
                const self = this
                ElementDialog.createDialog('修改流水线阶段', window.contextPath + 'page/allintpaas/batch/conf/BatBatchStageConfigUpdate.html?' + 'stageId=' + row.stageId + '&batchId=' + row.batchId).then(self.queryList);
            },
            doStageDelete(row) {
                const self = this
                if (row) {
                    const param = Vue.unref(row);
                    self.currentRow = param;
                    ElementPlus.ElMessageBox.confirm(
                        '你确定要删除这条记录?',
                        '提示',
                        {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning',
                        }
                    ).then(() => {
                        $.restfulPostJson(window.contextPath + 'api/BatBatchStageConfig/deleteByPk', row, function(data) {
                            if (data.success) {
                                // 删除阶段下的任务
                                $.restfulPostJson(window.contextPath + 'api/BatBatchStageConfigManual/deleteTaskByStage', row, function(data) {});
                                ElementPlus.ElMessage({
                                    showClose: true,
                                    message: '删除成功',
                                    type: 'success',
                                })
                                self.queryList();
                            }
                        });
                    })
                }
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
        },
        computed:{
            DIC() {
                return {
                    SOLUTION_TYPE: window.SOLUTION_TYPE || [],

                }
            },
            breadcrumb() {
                return [ `${this.batchName}`+ '编辑']
            },
            tableStyle() {
                return {
                    width: this.stageList.length * 300,
                    'min-height': '70%'
                }
            }
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24" class="dev-card-col"  style="margin-top: 30px;">
            <el-scrollbar >
                <table class="bat-table" :style="tableStyle">
                    <thead>
                        <tr>
                            <th v-for="(stage, index) in stageList">
                                <div :key="index" class="bat-thead-th-cell">
                                    <div class="bat-table-stage-name"><el-button class="bat-table-stage-num" size="small" type="primary" circle >{{index + 1}}</el-button><span>{{ stage.stageName }}</span></div>
                                    <el-dropdown @command="handlerCommand" type="primary" class="bat-table-stage-op">
                                        <el-button type="default" text icon="Setting" size="small" ></el-button>
                                        <template #dropdown>
                                            <el-dropdown-menu>
                                                <el-dropdown-item :command="{ command: 'doStageAdd', row: stage}"><el-icon><Edit ></Edit></el-icon>添加节点</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doStageUpdate', row: stage}"><el-icon><Edit ></Edit></el-icon>修改节点</el-dropdown-item>
                                                <el-dropdown-item :command="{ command: 'doStageDelete', row: stage}"><el-icon><Delete ></Delete></el-icon>删除节点</el-dropdown-item>
                                            </el-dropdown-menu>
                                        </template>
                                    </el-dropdown>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody style="background-color: #FFF;">
                        <tr>
                            <td v-for="(stage, index) in stageList">
                                <div class="bat-tasks" >
                                    <div v-if="!stage.taskList || stage.taskList.length == 0" style="text-align:center;">
                                       <el-button @click="doAdd(stage)" type="default" circle  icon="Plus" size="small"></el-button>
                                    </div>
                                    <div class="bat-task" v-for="(task, tIndex) in stage.taskList" @dblclick.prevent="doUpdate(task)">
                                        <div class="bat-task-item">
                                            <div class="bat-task-icon"> <i class="iconfont icon-task"></i> </div>
                                            <div class="bat-task-text">{{ task.taskName }}</div>
                                        </div>
                                        <div class="bat-task-line" v-if="tIndex < stage.taskList.length - 1"> <i></i> </div>
                                        <div class="bat-task-btn"  v-if="tIndex == stage.taskList.length - 1">
                                               <el-button class="bat-task-add-el-button" @click="doAdd(stage)" type="default" circle  icon="Plus" size="small"></el-button>
                                        </div>
                                        <div class="bat-task-btn" >
                                               <el-button class="bat-task-del-el-button" @click="doDelete(task)" type="danger" circle  icon="CloseBold" size="small"></el-button>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </el-scrollbar>
</el-col>
        `,
    }

}));