/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.autoconfigure;

import com.irdstudio.allintpaas.batch.engine.executor.rest.init.ActiveConsoleExecutor;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.irdstudio.allintpaas.batch.engine"})
public class AllintpaasBatchEngineAutoConfiguration {
    @Bean
    public MapperScannerConfigurer allintpaasBatchEngineMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintpaas.batch.engine.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils utils = new SpringContextUtils();
        utils.setApplicationContext(ctx);
        return utils;
    }

    @Bean
    @ConditionalOnMissingBean(value={ActiveConsoleExecutor.class})
    public ActiveConsoleExecutor activeConsoleExecutor_batch_engine() {
        ActiveConsoleExecutor activeConsoleExecutor = new ActiveConsoleExecutor();
        activeConsoleExecutor.activeConsoleExecutor();
        return activeConsoleExecutor;
    }

    @Configuration
    @EnableWebMvc
    public class AllintpaasBatchEngineMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

