/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.dict.autoconfigure;

import com.irdstudio.allintpaas.sdk.dict.web.operation.SpringBootDictInitController;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={SpringBootDictInitController.class})
@ConditionalOnMissingClass(value={"com.irdstudio.framework.beans.ssm.init.SpringBootDictInitController", "com.irdstudio.sdk.ssm.init.SpringBootDictInitController"})
@ComponentScan(value={"com.irdstudio.allintpaas.sdk.dict"})
public class SdkDictAutoConfiguration {
    @Bean
    public MapperScannerConfigurer dictMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintpaas.sdk.dict.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils() {
        return new SpringContextUtils();
    }

    @Configuration
    @EnableWebMvc
    public class DicMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

