/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.beans.mq.client.producer;

import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQProducerMessageClient {
    private static Logger logger = LoggerFactory.getLogger(MQProducerMessageClient.class);
    private DefaultMQProducer producer;
    private String producerGroup;
    private String namesrvAddr;
    private String retryAnotherBrokerWhenNotStoreOK;

    public void init() throws MQClientException {
        logger.info("Producer initialize!!" + this.producerGroup + this.namesrvAddr);
        this.producer = new DefaultMQProducer(this.producerGroup);
        this.producer.setNamesrvAddr(this.namesrvAddr);
        this.producer.setInstanceName(String.valueOf(System.currentTimeMillis()));
        this.producer.start();
        logger.info("Producer start success!");
    }

    public void desdory() {
        this.producer.shutdown();
    }

    public void sendMsg(Message msg) {
        SendResult sendResult = null;
        try {
            sendResult = this.producer.send(msg);
            logger.info(sendResult.toString());
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (RemotingException e) {
            logger.error("RemotingException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (MQClientException e) {
            logger.error("MQClientException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (MQBrokerException e) {
            logger.error("MQBrokerException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage() + String.valueOf(sendResult));
        }
        if (sendResult == null || sendResult.getSendStatus() != SendStatus.SEND_OK) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\uff01\uff01\uff01" + sendResult);
        }
    }

    public void sendMsg(Message msg, int leval) {
        SendResult sendResult = null;
        try {
            msg.setDelayTimeLevel(leval);
            sendResult = this.producer.send(msg);
            logger.info(sendResult.toString());
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (RemotingException e) {
            logger.error("RemotingException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (MQClientException e) {
            logger.error("MQClientException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (MQBrokerException e) {
            logger.error("MQBrokerException" + e.getMessage() + String.valueOf(sendResult));
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage() + String.valueOf(sendResult));
        }
        if (sendResult == null || sendResult.getSendStatus() != SendStatus.SEND_OK) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\uff01\uff01\uff01" + sendResult);
        }
    }

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getRetryAnotherBrokerWhenNotStoreOK() {
        return this.retryAnotherBrokerWhenNotStoreOK;
    }

    public void setRetryAnotherBrokerWhenNotStoreOK(String retryAnotherBrokerWhenNotStoreOK) {
        this.retryAnotherBrokerWhenNotStoreOK = retryAnotherBrokerWhenNotStoreOK;
    }
}

