/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.beans.sqlite.cache;

import com.irdstudio.basic.beans.sqlite.vo.BeanColumnMap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqliteCache {
    private static boolean hasLoadDbFilePathToMap = false;
    private static Map<String, String> EXISTS_DB = new HashMap<String, String>();
    public static String DB_FILE_POSTFIX = ".db";
    private static String DEFAULT_SRC_DBFILE_PATH = null;
    private static Map<String, List<BeanColumnMap>> BEAN_TABLE_MAP = new HashMap<String, List<BeanColumnMap>>();

    public static void loadDbFilePath(String dbFilePath) {
        if (!hasLoadDbFilePathToMap) {
            File[] files;
            File dbSaveDir = new File(dbFilePath.replaceAll("//", ""));
            for (File f : files = dbSaveDir.listFiles()) {
                if (f.getName().indexOf(DB_FILE_POSTFIX) == -1) continue;
                EXISTS_DB.put(f.getName().replaceAll(DB_FILE_POSTFIX, ""), f.getAbsolutePath());
                if (DEFAULT_SRC_DBFILE_PATH != null && !"".equals(DEFAULT_SRC_DBFILE_PATH)) continue;
                DEFAULT_SRC_DBFILE_PATH = f.getAbsolutePath();
            }
            hasLoadDbFilePathToMap = true;
        }
    }

    public static boolean dbMapIsEmpty() {
        return EXISTS_DB.isEmpty();
    }

    public static boolean checkIfDbFileExists(String dbFilePath, String appId) {
        SqliteCache.loadDbFilePath(dbFilePath);
        return EXISTS_DB.containsKey(appId) && EXISTS_DB.get(appId) != null && !"".equals(EXISTS_DB.get(appId));
    }

    public static String getDbFilePathByAppIdFromMap(String appId) {
        return EXISTS_DB.containsKey(appId) ? EXISTS_DB.get(appId) : null;
    }

    public static void setToExistsDb(String appId, String dbFilePath) {
        EXISTS_DB.put(appId, dbFilePath);
    }

    public static String getDefaultSrcDbfilePath() {
        return DEFAULT_SRC_DBFILE_PATH;
    }

    public static List<BeanColumnMap> getBeanTableMap(String className) {
        List<BeanColumnMap> list = null;
        if (BEAN_TABLE_MAP.containsKey(className)) {
            list = BEAN_TABLE_MAP.get(className);
        }
        return list;
    }

    public static void setBeanTableMap(String className, List<BeanColumnMap> list) {
        BEAN_TABLE_MAP.put(className, list);
    }
}

