/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.boot.config;

import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@Configuration
public class TransactionAspConfig {
    private static final String AOP_POINTCUT_EXPRESSION = "execution (* com.***.service.impl.*.*(..))";

    @Autowired
    @Bean
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        return transactionManager;
    }

    @Autowired
    @Bean
    public TransactionInterceptor txAdvice(TransactionManager transactionManager) {
        DefaultTransactionAttribute txAttr_REQUIRED = new DefaultTransactionAttribute();
        txAttr_REQUIRED.setPropagationBehavior(0);
        DefaultTransactionAttribute txAttr_REQUIRED_READONLY = new DefaultTransactionAttribute();
        txAttr_REQUIRED_READONLY.setPropagationBehavior(0);
        txAttr_REQUIRED_READONLY.setReadOnly(true);
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        source.addTransactionalMethod("add*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("append*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("insert*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("modify*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("edit*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("save*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("delete*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("update*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("exec*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("set*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("get*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("query*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("find*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("list*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("count*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("is*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        return new TransactionInterceptor(transactionManager, (TransactionAttributeSource)source);
    }

    @Autowired
    @Qualifier(value="txAdvice")
    @Bean
    public Advisor txAdviceAdvisor(TransactionInterceptor txAdvice) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)txAdvice);
    }
}

