/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core;

import com.irdstudio.bfp.executor.core.BpaDataUtil;
import com.irdstudio.bfp.executor.core.BpaRunProcess;
import com.irdstudio.bfp.executor.core.dao.domain.BpaTaskInfo;
import com.irdstudio.bfp.executor.core.plugin.PluginContext;
import com.irdstudio.bfp.executor.core.plugin.PluginExecutor;
import com.irdstudio.bfp.executor.core.plugin.PluginLogService;
import com.irdstudio.bfp.executor.core.tinycore.log.ILogger;
import com.irdstudio.bfp.executor.core.tinycore.log.TLogger;
import com.irdstudio.bfp.executor.core.utils.date.DateVerify;
import com.irdstudio.bfp.executor.core.utils.pub.Convert;
import com.irdstudio.bfp.executor.core.vo.BpaInstInfo;
import com.irdstudio.bfp.executor.core.vo.BpaInstTask;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.sql.SQLException;

public class BpaTaskThread
extends Thread {
    private BpaInstInfo batchInst = null;
    private BpaInstTask taskInst = null;
    private BpaTaskInfo taskConf = null;
    private ILogger logger = null;
    private PluginLogService taskLogService = null;
    public static final int TASK_RUN_TYPE_NORMAL = 1;
    public static final int TASK_RUN_TYPE_CYCLE = 2;
    public static final int TASK_RUN_TYPE_CRON = 3;
    public BpaRunProcess batchRunProcess;

    public BpaTaskThread(BpaInstInfo batchInst, BpaInstTask taskInst, BpaTaskInfo taskConf, BpaRunProcess batchRunProcess) {
        this.batchInst = batchInst;
        this.taskInst = taskInst;
        this.taskConf = taskConf;
        this.taskLogService = PluginLogService.getInstance();
        this.batchRunProcess = batchRunProcess;
    }

    @Override
    public void run() {
        this.logger = TLogger.getLogger(this.batchInst.getBpaSerialNo());
        int taskRunType = Convert.StrToInt(this.taskConf.getTaskRunType());
        switch (taskRunType) {
            case 1: {
                this.doNomalTask();
                break;
            }
            case 2: {
                this.doCycleTask();
                break;
            }
            case 3: {
                this.doCronTask();
            }
        }
        this.batchRunProcess.doTaskTheadCalc(-1);
    }

    private void doNomalTask() {
        this.logger.debug(this.taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        PluginContext ctx = this.newPluginContext();
        if (this.callPlugin(ctx)) {
            this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, ctx.getStartMills(), "6");
        } else {
            this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, ctx.getStartMills(), "7");
        }
        this.logger.debug(this.taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
    }

    private void doCronTask() {
        this.logger.debug(this.taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u5b9a\u65f6\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        if (StringUtil.isStrEmpty((String)this.taskConf.getTaskCycleType())) {
            this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, System.currentTimeMillis(), "7");
        } else {
            boolean isCanExecute = false;
            if ("M".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBpaDate(), 2);
            } else if ("S".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBpaDate(), 4);
            } else if ("Y".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBpaDate(), 3);
            } else if ("W".equals(this.taskConf.getTaskCycleType())) {
                isCanExecute = DateVerify.isDateTail(this.taskInst.getBpaDate(), 2);
            }
            if (isCanExecute) {
                PluginContext ctx = this.newPluginContext();
                if (this.callPlugin(ctx)) {
                    this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, ctx.getStartMills(), "6");
                } else {
                    this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, ctx.getStartMills(), "7");
                }
            } else {
                this.taskLogService.updateBatchTaskToEndEx(this.taskInst.getBpaSerialNo(), this.taskConf, System.currentTimeMillis(), "7");
            }
        }
        this.logger.debug(this.taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u5b9a\u65f6\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
    }

    private void doCycleTask() {
        this.logger.debug(this.taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u8f6e\u8be2\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        int accTime = 0;
        int cycleInteval = this.taskConf.getCycleInteval();
        int maxWaitTime = this.taskConf.getMaxWaitTime();
        PluginContext ctx = this.newPluginContext();
        boolean bResult = this.callPlugin(ctx);
        while (!(bResult || maxWaitTime > 0 && accTime >= maxWaitTime)) {
            try {
                accTime += cycleInteval;
                Thread.sleep((long)cycleInteval * 1000L);
                String state = BpaDataUtil.getTaskState(this.taskInst.getTaskId());
                if ("1".equals(state)) {
                    bResult = true;
                    break;
                }
                if ("3".equals(state)) {
                    bResult = false;
                    break;
                }
                bResult = this.callPlugin(ctx);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        }
        if (bResult) {
            this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, ctx.getStartMills(), "6");
        } else {
            this.taskLogService.updateBatchTaskToEnd(this.taskInst.getBpaSerialNo(), this.taskConf, ctx.getStartMills(), "7");
        }
        this.logger.debug(this.taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u8f6e\u8be2\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
    }

    private PluginContext newPluginContext() {
        PluginContext ctx = new PluginContext();
        ctx.setnPluginId(this.taskConf.getPluginId());
        ctx.setSzPluginParam(this.taskInst.getPluginParam());
        ctx.setnPluginConfType(Convert.StrToInt(this.taskConf.getPluginSourceType(), 1));
        ctx.setSzPluginConfId(this.taskConf.getPluginParaFlag());
        ctx.setSzBatchSn(this.batchInst.getBpaSerialNo());
        ctx.setSzBatchId(this.batchInst.getBpaId());
        ctx.setSzTaskId(this.taskInst.getTaskId());
        ctx.setSzTaskName(this.taskInst.getTaskName());
        ctx.setSzSubsCode(this.batchInst.getSubsCode());
        ctx.setSzSubsDsCode(this.taskConf.getSubsDsCode());
        return ctx;
    }

    private boolean callPlugin(PluginContext ctx) {
        boolean bIsCallSuccess = false;
        try {
            this.taskLogService.updateBatchTaskToRunning(ctx.getSzBatchSn(), ctx.getSzTaskId());
            bIsCallSuccess = PluginExecutor.callPlugin(ctx);
        }
        catch (SQLException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        return bIsCallSuccess;
    }
}

