/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.dao;

import com.irdstudio.bfp.executor.core.dao.domain.BpmBaseInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BpmBaseInfoDao {
    Connection conn = null;

    public BpmBaseInfoDao(Connection conn) {
        this.conn = conn;
    }

    public BpmBaseInfo queryByBpmCodeAndLatestState(String bpmCode, String latestState) throws SQLException {
        BpmBaseInfo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bpm_base_info WHERE bpm_code=? and latest_state=?");
            ps.setString(1, bpmCode);
            ps.setString(2, latestState);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BpmBaseInfo();
                dc.setBpmId(rs.getString("bpm_id"));
                dc.setBpmName(rs.getString("bpm_name"));
                dc.setEquallyTaskAmount(rs.getInt("equally_task_amount"));
                dc.setIsRunAgain(rs.getString("is_run_again"));
                dc.setCreateUser(rs.getString("create_user"));
                dc.setCreateTime(rs.getString("create_time"));
                dc.setLastUpdateUser(rs.getString("last_update_user"));
                dc.setLastUpdateTime(rs.getString("last_update_time"));
                dc.setBpmType(rs.getString("bpm_type"));
                dc.setBpmVersion(rs.getString("bpm_version"));
                dc.setBpmState(rs.getString("bpm_state"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setCategoryTag(rs.getString("category_tag"));
                dc.setBpmCode(rs.getString("bpm_code"));
                dc.setEffectState(rs.getString("effect_state"));
                dc.setLatestState(rs.getString("latest_state"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryByBpmCodeAndLatestState is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public BpmBaseInfo queryByBpmCodeAndBpmVersion(String bpmCode, String bpmVersion) throws SQLException {
        BpmBaseInfo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bpm_base_info WHERE bpm_code=? and bpm_version=?");
            ps.setString(1, bpmCode);
            ps.setString(2, bpmVersion);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BpmBaseInfo();
                dc.setBpmId(rs.getString("bpm_id"));
                dc.setBpmName(rs.getString("bpm_name"));
                dc.setEquallyTaskAmount(rs.getInt("equally_task_amount"));
                dc.setIsRunAgain(rs.getString("is_run_again"));
                dc.setCreateUser(rs.getString("create_user"));
                dc.setCreateTime(rs.getString("create_time"));
                dc.setLastUpdateUser(rs.getString("last_update_user"));
                dc.setLastUpdateTime(rs.getString("last_update_time"));
                dc.setBpmType(rs.getString("bpm_type"));
                dc.setBpmVersion(rs.getString("bpm_version"));
                dc.setBpmState(rs.getString("bpm_state"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setCategoryTag(rs.getString("category_tag"));
                dc.setBpmCode(rs.getString("bpm_code"));
                dc.setEffectState(rs.getString("effect_state"));
                dc.setLatestState(rs.getString("latest_state"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryByBpmCodeAndLatestState is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public int insertBpmBaseInfo(BpmBaseInfo bpmBaseInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into bpm_base_info ( bpm_id,bpm_name,bpm_type,bpm_version,equally_task_amount,is_run_again,bpm_state,subs_code,category_tag,create_user,create_time,last_update_user,last_update_time) values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setObject(1, bpmBaseInfo.getBpmId());
            ps.setObject(2, bpmBaseInfo.getBpmName());
            ps.setObject(3, bpmBaseInfo.getBpmType());
            ps.setObject(4, bpmBaseInfo.getBpmVersion());
            ps.setObject(5, bpmBaseInfo.getEquallyTaskAmount());
            ps.setObject(6, bpmBaseInfo.getIsRunAgain());
            ps.setObject(7, bpmBaseInfo.getBpmState());
            ps.setObject(8, bpmBaseInfo.getSubsCode());
            ps.setObject(9, bpmBaseInfo.getCategoryTag());
            ps.setObject(10, bpmBaseInfo.getCreateUser());
            ps.setObject(11, bpmBaseInfo.getCreateTime());
            ps.setObject(12, bpmBaseInfo.getLastUpdateUser());
            ps.setObject(13, bpmBaseInfo.getLastUpdateTime());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert BpmBaseInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteByPk(BpmBaseInfo bpmBaseInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("delete from bpm_base_info where 1=1 AND bpm_id = ? ");
            ps.setObject(1, bpmBaseInfo.getBpmId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("delete BpmBaseInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int updateByPk(BpmBaseInfo bpmBaseInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("update bpm_base_info set  bpm_id = ? , bpm_name = ? , bpm_type = ? , bpm_version = ? , equally_task_amount = ? , is_run_again = ? , bpm_state = ? , subs_code = ? , category_tag = ? , create_user = ? , create_time = ? , last_update_user = ? , last_update_time = ?  where 1=1 AND bpm_id = ? ");
            ps.setObject(1, bpmBaseInfo.getBpmId());
            ps.setObject(2, bpmBaseInfo.getBpmName());
            ps.setObject(3, bpmBaseInfo.getBpmType());
            ps.setObject(4, bpmBaseInfo.getBpmVersion());
            ps.setObject(5, bpmBaseInfo.getEquallyTaskAmount());
            ps.setObject(6, bpmBaseInfo.getIsRunAgain());
            ps.setObject(7, bpmBaseInfo.getBpmState());
            ps.setObject(8, bpmBaseInfo.getSubsCode());
            ps.setObject(9, bpmBaseInfo.getCategoryTag());
            ps.setObject(10, bpmBaseInfo.getCreateUser());
            ps.setObject(11, bpmBaseInfo.getCreateTime());
            ps.setObject(12, bpmBaseInfo.getLastUpdateUser());
            ps.setObject(13, bpmBaseInfo.getLastUpdateTime());
            ps.setObject(14, bpmBaseInfo.getBpmId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("update BpmBaseInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public BpmBaseInfo queryByPk(BpmBaseInfo bpmBaseInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        BpmBaseInfo result = null;
        try {
            ps = this.conn.prepareStatement("select bpm_id,bpm_name,bpm_type,bpm_version,equally_task_amount,is_run_again,bpm_state,subs_code,category_tag,create_user,create_time,last_update_user,last_update_timefrom bpm_base_info where 1=1  AND bpm_id = ? ");
            ps.setObject(1, bpmBaseInfo.getBpmId());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new BpmBaseInfo();
                result.setBpmId(rs.getString("bpm_id"));
                result.setBpmName(rs.getString("bpm_name"));
                result.setBpmType(rs.getString("bpm_type"));
                result.setBpmVersion(rs.getString("bpm_version"));
                result.setIsRunAgain(rs.getString("is_run_again"));
                result.setBpmState(rs.getString("bpm_state"));
                result.setSubsCode(rs.getString("subs_code"));
                result.setCategoryTag(rs.getString("category_tag"));
                result.setCreateUser(rs.getString("create_user"));
                result.setCreateTime(rs.getString("create_time"));
                result.setLastUpdateUser(rs.getString("last_update_user"));
                result.setLastUpdateTime(rs.getString("last_update_time"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update BpmBaseInfo is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<BpmBaseInfo> queryAll(BpmBaseInfo bpmBaseInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<BpmBaseInfo> result = new ArrayList<BpmBaseInfo>();
        try {
            String sql = "select bpm_id,bpm_name,bpm_type,bpm_version,equally_task_amount,is_run_again,bpm_state,subs_code,category_tag,create_user,create_time,last_update_user,last_update_timefrom bpm_base_info where 1=1 ";
            if (bpmBaseInfo.getBpmId() != null) {
                sql = sql + " AND bpm_id =  '" + bpmBaseInfo.getBpmId() + "'";
            }
            if (bpmBaseInfo.getBpmName() != null) {
                sql = sql + " AND bpm_name =  '" + bpmBaseInfo.getBpmName() + "'";
            }
            if (bpmBaseInfo.getBpmType() != null) {
                sql = sql + " AND bpm_type =  '" + bpmBaseInfo.getBpmType() + "'";
            }
            if (bpmBaseInfo.getBpmVersion() != null) {
                sql = sql + " AND bpm_version =  '" + bpmBaseInfo.getBpmVersion() + "'";
            }
            if (bpmBaseInfo.getEquallyTaskAmount() != null) {
                sql = sql + " AND equally_task_amount =  '" + bpmBaseInfo.getEquallyTaskAmount() + "'";
            }
            if (bpmBaseInfo.getIsRunAgain() != null) {
                sql = sql + " AND is_run_again =  '" + bpmBaseInfo.getIsRunAgain() + "'";
            }
            if (bpmBaseInfo.getBpmState() != null) {
                sql = sql + " AND bpm_state =  '" + bpmBaseInfo.getBpmState() + "'";
            }
            if (bpmBaseInfo.getSubsCode() != null) {
                sql = sql + " AND subs_code =  '" + bpmBaseInfo.getSubsCode() + "'";
            }
            if (bpmBaseInfo.getCategoryTag() != null) {
                sql = sql + " AND category_tag =  '" + bpmBaseInfo.getCategoryTag() + "'";
            }
            if (bpmBaseInfo.getCreateUser() != null) {
                sql = sql + " AND create_user =  '" + bpmBaseInfo.getCreateUser() + "'";
            }
            if (bpmBaseInfo.getCreateTime() != null) {
                sql = sql + " AND create_time =  '" + bpmBaseInfo.getCreateTime() + "'";
            }
            if (bpmBaseInfo.getLastUpdateUser() != null) {
                sql = sql + " AND last_update_user =  '" + bpmBaseInfo.getLastUpdateUser() + "'";
            }
            if (bpmBaseInfo.getLastUpdateTime() != null) {
                sql = sql + " AND last_update_time =  '" + bpmBaseInfo.getLastUpdateTime() + "'";
            }
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                BpmBaseInfo obj = new BpmBaseInfo();
                obj.setBpmId(rs.getString("bpm_id"));
                obj.setBpmName(rs.getString("bpm_name"));
                obj.setBpmType(rs.getString("bpm_type"));
                obj.setBpmVersion(rs.getString("bpm_version"));
                obj.setIsRunAgain(rs.getString("is_run_again"));
                obj.setBpmState(rs.getString("bpm_state"));
                obj.setSubsCode(rs.getString("subs_code"));
                obj.setCategoryTag(rs.getString("category_tag"));
                obj.setCreateUser(rs.getString("create_user"));
                obj.setCreateTime(rs.getString("create_time"));
                obj.setLastUpdateUser(rs.getString("last_update_user"));
                obj.setLastUpdateTime(rs.getString("last_update_time"));
                result.add(obj);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update BpmBaseInfo is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

