/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.api.rest;

import com.irdstudio.bfp.executor.core.dao.BpmBaseInfoDao;
import com.irdstudio.bfp.executor.core.dao.domain.BpmBaseInfo;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.rest.api.rest.vo.ResponseVO;
import com.irdstudio.bfp.executor.rest.engine.BpwRunEngine;
import java.sql.Connection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/executor"})
public class BpwController {
    private static final Logger logger = LoggerFactory.getLogger(BpwController.class);

    @RequestMapping(value={"/bpw/start"}, method={RequestMethod.GET})
    public ResponseVO startBpmProcess(@RequestParam(value="wfiSerialNo") String wfiSerialNo, @RequestParam(value="bpmCode") String bpmCode, @RequestParam(value="bpmVersion") String bpmVersion, @RequestParam(value="params") String param) {
        logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u5f00\u59cb......");
        ResponseVO vo = new ResponseVO();
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BpmBaseInfoDao bpmBaseInfoDao = new BpmBaseInfoDao(conn);
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            bpmBaseInfo = StringUtils.isNotBlank((String)bpmVersion) && !"null".equals(bpmVersion) ? bpmBaseInfoDao.queryByBpmCodeAndBpmVersion(bpmCode, bpmVersion) : bpmBaseInfoDao.queryByBpmCodeAndLatestState(bpmCode, "Y");
            logger.info("\u5ba1\u6279\u6d41\u7a0bID\u4e3a\uff1a " + bpmBaseInfo.getBpmId());
            logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u5f00\u59cb, \u5ba1\u6279\u6d41\u7a0b\u6d41\u6c34\u53f7\uff1a" + wfiSerialNo + "\uff0c\u5ba1\u6279\u6d41\u7a0bID\uff1a" + bpmBaseInfo.getBpmId() + "\uff0c\u81ea\u52a8\u6d41\u7a0b\u7248\u672c\uff1a" + bpmVersion + ", \u5ba1\u6279\u6d41\u7a0b\u52a8\u4f5c\uff1a" + param);
            BpwRunEngine bpwRunEngine = new BpwRunEngine(wfiSerialNo, bpmBaseInfo.getBpmId(), param);
            bpwRunEngine.start();
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u5ba1\u6279\u6d41\u7a0b");
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }
}

