/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.init;

import com.irdstudio.bfp.executor.core.tinycore.log.ILogger;
import com.irdstudio.bfp.executor.core.tinycore.log.TLogger;
import com.irdstudio.bfp.executor.rest.init.ExecutorInstInfo;
import com.irdstudio.sdk.beans.core.util.PathUtil;
import java.io.File;
import java.util.ResourceBundle;

public class ExecutorResourceLoader {
    private static ExecutorResourceLoader inst = null;
    private String projectRootPath = "";
    private ILogger logger = null;

    public static synchronized ExecutorResourceLoader me() {
        if (inst == null) {
            inst = new ExecutorResourceLoader();
        }
        return inst;
    }

    public void loadGlobalConfigure() {
        this.projectRootPath = PathUtil.getProjectRootPath();
        ResourceBundle bundle = ResourceBundle.getBundle("application");
        ExecutorInstInfo.BATCH_LOG_PATH = this.formatPath(bundle.getString("agent.batch.log.path"));
        ExecutorInstInfo.EXECUTOR_MODE = bundle.getString("agent.mode");
        ExecutorInstInfo.EXECUTOR_ID = bundle.getString("agent.id");
        File file = new File(ExecutorInstInfo.BATCH_LOG_PATH);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.logger.info(" \u81ea\u52a8\u6d41\u7a0b\u670d\u52a1\u65e5\u5fd7\u8def\u5f84 :" + ExecutorInstInfo.BATCH_LOG_PATH);
    }

    private String formatPath(String path) {
        if (PathUtil.isAbsolutePath((String)path)) {
            return path;
        }
        return this.projectRootPath + path;
    }

    public void start() {
        this.logger = TLogger.getLogger("resource");
        this.loadGlobalConfigure();
    }
}

