/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core;

import com.irdstudio.bfp.executor.core.BpaTaskThread;
import com.irdstudio.bfp.executor.core.dao.domain.BpaBaseInfo;
import com.irdstudio.bfp.executor.core.dao.domain.BpaTaskInfo;
import com.irdstudio.bfp.executor.core.job.JavaDataJobDao;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.tinycore.log.ILogger;
import com.irdstudio.bfp.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.bfp.executor.core.tinycore.log.TLogger;
import com.irdstudio.bfp.executor.core.tinycore.thread.TThreadPools;
import com.irdstudio.bfp.executor.core.utils.pub.Convert;
import com.irdstudio.bfp.executor.core.vo.BpaInstInfo;
import com.irdstudio.bfp.executor.core.vo.BpaInstTask;
import com.irdstudio.bfp.executor.core.vo.BpaStageInfo;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class BpaRunProcess
extends Thread {
    private String batchId = "";
    private String batchSerialNo;
    private BpaBaseInfo batchConfig = null;
    private String batchLogPath;
    private BpaInstInfo batchInst = null;
    private Map<String, BpaTaskInfo> taskConfigMap = null;
    private int runState = 8;
    private int equallyTaskAmount = 0;
    private Integer taskThreadAmount = 0;
    private Connection conn = null;
    private ILogger logger = null;
    private ExecutorService threadPool = null;
    private static final Object taskThreadAmountLock = new Object();

    public BpaRunProcess(String batchSerialNo, BpaBaseInfo batchConfig, String batchLogPath) {
        this.batchSerialNo = batchSerialNo;
        this.batchConfig = batchConfig;
        this.batchLogPath = batchLogPath;
    }

    public BpaRunProcess(String batchId) {
        this.batchId = batchId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JavaDataJobDao dao = null;
        String sql = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            this.conn = TConnPool.getDefaultPool().getConnection();
            dao = new JavaDataJobDao(this.conn, true);
            if (null == this.batchConfig) {
                sql = "select * from bpa_base_info where bpa_id = ?";
                values.clear();
                values.add(this.batchId);
                this.batchConfig = dao.querySingle(sql, values, BpaBaseInfo.class);
            } else {
                this.batchId = this.batchConfig.getBpaId();
            }
            sql = "select * from bpa_inst_info where bpa_serial_no = ?";
            values.clear();
            values.add(this.batchSerialNo);
            this.batchInst = dao.querySingle(sql, values, BpaInstInfo.class);
            if (this.batchInst == null) {
                throw new SQLException("\u672a\u8bfb\u53d6\u5230\u4e1a\u52a1\u6d41\u8f6c\u5b9e\u4f8b:" + this.batchSerialNo);
            }
            this.threadPool = TThreadPools.getThreadPool(this.batchSerialNo);
            String fullLogFileName = this.batchLogPath + File.separator + this.batchSerialNo + ".log";
            System.err.println(fullLogFileName);
            ILogger fileLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
            fileLogger.setName(this.batchSerialNo);
            TLogger.registerCategoryLogger(this.batchSerialNo, fileLogger);
            this.logger = TLogger.getLogger(this.batchSerialNo);
            this.logger.info("\u4e1a\u52a1\u6d41\u8f6c[" + this.batchSerialNo + "]\u81ea\u52a8\u6d41\u7a0b\u5f00\u59cb...");
            this.equallyTaskAmount = this.batchConfig.getEquallyTaskAmount();
            this.batchInst.setStartTime(TimeUtil.getCurrentDateTime());
            this.taskConfigMap = new Hashtable<String, BpaTaskInfo>();
            sql = "select * from bpa_task_info where bpa_id = ? and task_use_state = ?";
            values.clear();
            values.add(this.batchId);
            values.add("0");
            List<BpaTaskInfo> taskUnitConfigs = dao.queryList(sql, values, BpaTaskInfo.class);
            for (BpaTaskInfo config : taskUnitConfigs) {
                this.taskConfigMap.put(config.getTaskId(), config);
            }
            sql = "select * from bpa_stage_info where bpa_id = ? order by stage_id asc";
            values.clear();
            values.add(this.batchId);
            List<BpaStageInfo> stageConfigs = dao.queryList(sql, values, BpaStageInfo.class);
            String stageId = null;
            for (BpaStageInfo stageConfig : stageConfigs) {
                stageId = stageConfig.getStageId();
                this.batchInst.setStageId(stageId);
                sql = "update bpa_inst_info set bpa_state = ?, stage_id = ?, stage_name = ? where bpa_serial_no = ?";
                values.clear();
                values.add("3");
                values.add(stageId);
                values.add(stageConfig.getStageName());
                values.add(this.batchSerialNo);
                dao.update(sql, values);
                while (!this.doFinishStageAllTask(dao, stageId) && this.runState != 1) {
                    this.logger.info(Thread.currentThread().getName() + " Sleep 10 second!!!");
                    Thread.sleep(10000L);
                }
                if (this.runState != 1) continue;
                sql = "update bpa_inst_info set bpa_state = ? where bpa_serial_no = ?";
                values.clear();
                values.add("1");
                values.add(this.batchSerialNo);
                dao.update(sql, values);
                break;
            }
            if (this.runState != 1) {
                sql = "update bpa_inst_info set bpa_state = ?, end_time = ? where bpa_serial_no = ?";
                values.clear();
                values.add("9");
                values.add(TimeUtil.getCurrentDateTime());
                values.add(this.batchSerialNo);
                dao.update(sql, values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            sql = "update bpa_inst_info set bpa_state = ? where bpa_serial_no = ?";
            values.clear();
            values.add("1");
            values.add(this.batchSerialNo);
            dao.update(sql, values);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
            TThreadPools.showdownThreadPool(this.batchSerialNo);
            this.logger.info("\u81ea\u52a8\u6d41\u7a0b\u7ed3\u675f..." + Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFinishStageAllTask(JavaDataJobDao dao, String stageId) throws Exception {
        boolean bFinished = true;
        Object object = taskThreadAmountLock;
        synchronized (object) {
            if (this.taskThreadAmount >= this.equallyTaskAmount) {
                this.logger.info("\u8fbe\u5230\u6700\u5927\u5e76\u53d1\u6570--->taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                return false;
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "select * from bpa_inst_task where bpa_serial_no = ? and stage_id = ? order by task_run_state desc,task_id asc";
        values.add(this.batchSerialNo);
        values.add(stageId);
        List<BpaInstTask> allTaskList = dao.queryList(sql, values, BpaInstTask.class);
        if (allTaskList == null || allTaskList.size() == 0) {
            this.logger.info("bpa_serial_no [" + this.batchSerialNo + "] stage_id [" + stageId + "] has no task to run!!!");
            return true;
        }
        BpaTaskInfo taskConf = null;
        for (BpaInstTask taskInst : allTaskList) {
            taskConf = this.taskConfigMap.get(taskInst.getTaskId());
            this.runState = this.getBatchRunStateWithTask(taskInst, taskConf);
            if (this.runState == 1) {
                this.logger.info("batch_serial_no [" + this.batchSerialNo + "] stage_id [" + stageId + "]\u4e0b\u81ea\u52a8\u6d41\u7a0b\u4efb\u52a1\u8fd0\u884c\u5931\u8d25...");
                return false;
            }
            if (this.isTaskCanRun(taskInst, taskConf, dao)) {
                Object object2 = taskThreadAmountLock;
                synchronized (object2) {
                    if (this.taskThreadAmount >= this.equallyTaskAmount) {
                        this.logger.info("\u542f\u52a8\u4e00\u4e2a\u7ebf\u7a0b\u8fd0\u884c\u4efb\u52a1\u65f6\uff0c\u8fbe\u5230\u6700\u5927\u7ebf\u7a0b --> taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                        return false;
                    }
                    Integer n = this.taskThreadAmount;
                    Integer n2 = this.taskThreadAmount = Integer.valueOf(this.taskThreadAmount + 1);
                    this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u4efb\u52a1\u7ebf\u7a0b\u6570\uff1a" + this.taskThreadAmount);
                    BpaTaskThread taskThread = new BpaTaskThread(this.batchInst, taskInst, taskConf, this);
                    if (this.threadPool == null || this.threadPool.isTerminated()) {
                        this.threadPool = TThreadPools.getThreadPool(this.batchSerialNo);
                    }
                    this.threadPool.execute(taskThread);
                    this.logger.info("batch_serial_no [" + this.batchSerialNo + "] " + taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
                }
                bFinished = false;
                continue;
            }
            bFinished = bFinished && this.isTaskRunSuccess(taskInst);
        }
        return bFinished;
    }

    private boolean isTaskCanRun(BpaInstTask taskInst, BpaTaskInfo taskConf, JavaDataJobDao dao) throws Exception {
        boolean isCanRun = false;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if ((state == 0 || state == 1) && taskConf != null) {
            isCanRun = StringUtil.isNullorBank((String)taskConf.getPreviousTaskId()) || this.isPreviousTaskOk(taskConf.getPreviousTaskId(), dao);
        }
        return isCanRun;
    }

    private int getBatchRunStateWithTask(BpaInstTask taskInst, BpaTaskInfo taskConf) {
        int batchState = this.runState;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if (7 == state) {
            int skipTactic = Convert.StrToInt(taskConf.getTaskSkipTactic(), 2);
            if (skipTactic != 0) {
                if (skipTactic == 1) {
                    int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState());
                    if (interveneState != 1) {
                        batchState = 1;
                    }
                } else {
                    batchState = 1;
                }
            }
        } else {
            batchState = 3;
        }
        return batchState;
    }

    private boolean isPreviousTaskOk(String previousTaskId, JavaDataJobDao dao) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "select * from bpa_inst_task where bpa_serial_no = ? and task_id = ?";
        values.add(this.batchSerialNo);
        values.add(previousTaskId);
        BpaInstTask taskInst = dao.querySingle(sql, values, BpaInstTask.class);
        return this.isTaskRunSuccess(taskInst);
    }

    private boolean isTaskRunSuccess(BpaInstTask taskInst) {
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState(), 0);
        return state == 6 || interveneState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTaskTheadCalc(int i) {
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.taskThreadAmount = this.taskThreadAmount + i;
        }
    }
}

