/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.api.rest;

import com.irdstudio.bfp.executor.core.dao.BpmBaseInfoDao;
import com.irdstudio.bfp.executor.core.dao.domain.BpmBaseInfo;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.rest.api.rest.vo.ResponseVO;
import com.irdstudio.bfp.executor.rest.engine.BpaMultipleEngine;
import com.irdstudio.bfp.executor.rest.engine.BpaSimpleEngine;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/executor"})
public class BpaController {
    private static final Logger logger = LoggerFactory.getLogger(BpaController.class);

    @RequestMapping(value={"/bpa/start"}, method={RequestMethod.GET})
    public ResponseVO startSimpleBpmProcess(@RequestParam(value="bpaSerialNo") String bpaSerialNo, @RequestParam(value="bpmCode") String bpmCode, @RequestParam(value="bpmVersion") String bpmVersion, @RequestParam(value="batchAction") String batchAction) {
        logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5f00\u59cb......");
        ResponseVO vo = new ResponseVO();
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5f00\u59cb, \u81ea\u52a8\u6d41\u7a0b\u6d41\u6c34\u53f7\uff1a" + bpaSerialNo + "\uff0c\u81ea\u52a8\u6d41\u7a0b\u7f16\u53f7\uff1a" + bpmCode + "\uff0c\u81ea\u52a8\u6d41\u7a0b\u7248\u672c\uff1a" + bpmVersion + ", \u81ea\u52a8\u6d41\u7a0b\u52a8\u4f5c\uff1a" + batchAction);
            BpmBaseInfoDao bpmBaseInfoDao = new BpmBaseInfoDao(conn);
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            bpmBaseInfo = StringUtils.isNotBlank((String)bpmVersion) && !"null".equals(bpmVersion) ? bpmBaseInfoDao.queryByBpmCodeAndBpmVersion(bpmCode, bpmVersion) : bpmBaseInfoDao.queryByBpmCodeAndLatestState(bpmCode, "Y");
            logger.info("\u81ea\u52a8\u6d41\u7a0bID\u4e3a\uff1a " + bpmBaseInfo.getBpmId());
            BpaSimpleEngine batchEngine = new BpaSimpleEngine(batchAction, bpmBaseInfo.getBpmId(), bpaSerialNo);
            ApplicationThreadPool2 threadPool2 = (ApplicationThreadPool2)SpringContextUtils.getBean((String)"applicationThreadPool");
            threadPool2.add((Callable)batchEngine);
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u81ea\u52a8\u6d41\u7a0b");
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }

    @RequestMapping(value={"/bpa/start2"}, method={RequestMethod.GET})
    public ResponseVO startMultiBpaProcess(@RequestParam(value="bpaSerialNo") String bpaSerialNo, @RequestParam(value="bpmCode") String bpmCode, @RequestParam(value="bpmVersion") String bpmVersion, @RequestParam(value="batchAction") String batchAction) {
        logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5f00\u59cb......");
        ResponseVO vo = new ResponseVO();
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5f00\u59cb, \u81ea\u52a8\u6d41\u7a0b\u6d41\u6c34\u53f7\uff1a" + bpaSerialNo + "\uff0c\u81ea\u52a8\u6d41\u7a0b\u7f16\u53f7\uff1a" + bpmCode + "\uff0c\u81ea\u52a8\u6d41\u7a0b\u7248\u672c\uff1a" + bpmVersion + ", \u81ea\u52a8\u6d41\u7a0b\u52a8\u4f5c\uff1a" + batchAction);
            BpmBaseInfoDao bpmBaseInfoDao = new BpmBaseInfoDao(conn);
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            bpmBaseInfo = StringUtils.isNotBlank((String)bpmVersion) && !"null".equals(bpmVersion) ? bpmBaseInfoDao.queryByBpmCodeAndBpmVersion(bpmCode, bpmVersion) : bpmBaseInfoDao.queryByBpmCodeAndLatestState(bpmCode, "Y");
            logger.info("\u81ea\u52a8\u6d41\u7a0bID\u4e3a\uff1a " + bpmBaseInfo.getBpmId());
            BpaMultipleEngine batchEngine = new BpaMultipleEngine(batchAction, bpmBaseInfo.getBpmId(), bpaSerialNo);
            batchEngine.start();
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u81ea\u52a8\u6d41\u7a0b");
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }
}

