/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.engine;

import com.irdstudio.bfp.executor.core.BpaRunProcess;
import com.irdstudio.bfp.executor.core.dao.BpaBaseInfoDao;
import com.irdstudio.bfp.executor.core.dao.BpaInstInfoDao;
import com.irdstudio.bfp.executor.core.dao.BpaInstTaskDao;
import com.irdstudio.bfp.executor.core.dao.BpaTaskInfoDao;
import com.irdstudio.bfp.executor.core.dao.domain.BpaBaseInfo;
import com.irdstudio.bfp.executor.core.dao.domain.BpaInstInfo;
import com.irdstudio.bfp.executor.core.dao.domain.BpaInstTask;
import com.irdstudio.bfp.executor.core.dao.domain.BpaTaskInfo;
import com.irdstudio.bfp.executor.core.job.JavaDataJobDao;
import com.irdstudio.bfp.executor.core.plugin.PluginContext;
import com.irdstudio.bfp.executor.core.plugin.PluginExecutor;
import com.irdstudio.bfp.executor.core.plugin.PluginLogService;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.util.DataMoveUtil;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.util.TableMove;
import com.irdstudio.bfp.executor.core.tinycore.log.ILogger;
import com.irdstudio.bfp.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.bfp.executor.core.tinycore.log.TLogger;
import com.irdstudio.bfp.executor.core.utils.pub.Convert;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

public class BpaSimpleEngine
implements Callable<ExecuteRtnInfo> {
    private static final String BPA_RUN = "run";
    private static final String BPA_CONTINUE = "continue";
    private String bpaAction;
    private String bpaId;
    private String bpaSerialNo;
    private ILogger logger = null;

    public BpaSimpleEngine(String bpaAction, String bpaId, String bpaSerialNo) {
        this.bpaId = bpaId;
        this.bpaSerialNo = bpaSerialNo;
        this.bpaAction = bpaAction.toLowerCase();
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo executeRtnInfo = new ExecuteRtnInfo();
        try {
            if (BPA_RUN.equals(this.bpaAction)) {
                this.doRunBpaProcess();
            } else if (BPA_CONTINUE.equals(this.bpaAction)) {
                this.doContinueBpaProcess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return executeRtnInfo;
    }

    private void doRunBpaProcess() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BpaInstInfo bpaInstInfo = new BpaInstInfo();
            BpaInstInfoDao bpaInstInfoDao = new BpaInstInfoDao(conn);
            bpaInstInfo.setBpaSerialNo(this.bpaSerialNo);
            if (!Objects.isNull((Object)bpaInstInfoDao.queryByPk(bpaInstInfo))) {
                throw new Exception("\u5f53\u524d\u4e1a\u52a1\u6d41\u6c34\u53f7\u5df2\u7ecf\u53d1\u8d77\u81ea\u52a8\u6d41\u7a0b\uff0c\u4e0d\u5141\u8bb8\u518d\u53d1\u8d77\uff01");
            }
            BpaBaseInfoDao bpaBaseInfoDao = new BpaBaseInfoDao(conn);
            BpaBaseInfo queryBpaBaseInfo = new BpaBaseInfo();
            queryBpaBaseInfo.setBpaId(this.bpaId);
            BpaBaseInfo bpaBaseInfo = bpaBaseInfoDao.queryByPk(queryBpaBaseInfo);
            if (Objects.isNull((Object)bpaBaseInfo)) {
                throw new Exception("\u83b7\u53d6\u81ea\u52a8\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String bpaDate = TimeUtil.getCurDate();
            bpaInstInfo = new BpaInstInfo();
            bpaInstInfo.setBpaSerialNo(this.bpaSerialNo);
            bpaInstInfo.setBpaId(bpaBaseInfo.getBpaId());
            bpaInstInfo.setBpaName(bpaBaseInfo.getBpaName());
            bpaInstInfo.setBpaState("8");
            bpaInstInfo.setBpaInterveneState("0");
            bpaInstInfo.setBpaDate(bpaDate);
            bpaInstInfo.setStartTime(TimeUtil.getCurrentDateTime());
            bpaInstInfo.setSubsCode(bpaBaseInfo.getSubsCode());
            bpaInstInfoDao.insertBpaInstInfo(bpaInstInfo);
            BpaInstTask bpaInstTask = new BpaInstTask();
            BpaInstTaskDao bpaInstTaskDao = new BpaInstTaskDao(conn);
            bpaInstTask.setBpaSerialNo(this.bpaSerialNo);
            bpaInstTask.setBpaId(this.bpaId);
            bpaInstTask.setBpaDate(bpaDate);
            bpaInstTask.setTaskRunState("0");
            bpaInstTask.setTaskInterveneState("0");
            int count = bpaInstTaskDao.insertInstByInfo(bpaInstTask);
            if (count > 0) {
                String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
                String fullLogFileName = logPath + File.separator + this.bpaSerialNo + ".log";
                ILogger fileLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
                fileLogger.setName(this.bpaSerialNo);
                TLogger.registerCategoryLogger(this.bpaSerialNo, fileLogger);
                this.logger = TLogger.getLogger(this.bpaSerialNo);
                bpaInstInfo.setStartTime(TimeUtil.getCurrentDateTime());
                this.doFinishStageAllTask(conn, bpaInstInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private boolean doFinishStageAllTask(Connection conn, BpaInstInfo batchInst) throws Exception {
        boolean bFinished = true;
        Hashtable<String, BpaTaskInfo> taskConfigMap = new Hashtable<String, BpaTaskInfo>();
        BpaTaskInfo bpaTaskInfo = new BpaTaskInfo();
        BpaTaskInfoDao bpaTaskInfoDao = new BpaTaskInfoDao(conn);
        bpaTaskInfo.setBpaId(this.bpaId);
        List<BpaTaskInfo> taskUnitConfigs = bpaTaskInfoDao.queryAll(bpaTaskInfo);
        for (BpaTaskInfo config : taskUnitConfigs) {
            taskConfigMap.put(config.getTaskId(), config);
        }
        BpaInstTask bpaInstTask = new BpaInstTask();
        BpaInstTaskDao bpaInstTaskDao = new BpaInstTaskDao(conn);
        bpaInstTask.setBpaSerialNo(this.bpaSerialNo);
        List<BpaInstTask> allTaskList = bpaInstTaskDao.queryAll(bpaInstTask);
        BpaTaskInfo taskConf = null;
        for (BpaInstTask taskInst : allTaskList) {
            batchInst.setStageId(taskInst.getStageId());
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u5f00\u59cb\u6267\u884c...");
            this.logger.info(taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u666e\u901a\u4efb\u52a1:" + taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
            PluginContext ctx = new PluginContext();
            taskConf = (BpaTaskInfo)((Object)taskConfigMap.get(taskInst.getTaskId()));
            ctx.setnPluginId(taskConf.getPluginId());
            ctx.setSzPluginParam(taskInst.getPluginParam());
            ctx.setnPluginConfType(Convert.StrToInt(taskConf.getPluginSourceType(), 1));
            ctx.setSzPluginConfId(taskConf.getPluginParaFlag());
            ctx.setSzBatchSn(batchInst.getBpaSerialNo());
            ctx.setSzBatchId(batchInst.getBpaId());
            ctx.setSzTaskId(taskInst.getTaskId());
            ctx.setSzTaskName(taskInst.getTaskName());
            ctx.setSzSubsCode(batchInst.getSubsCode());
            ctx.setSzSubsDsCode(taskConf.getSubsDsCode());
            PluginLogService.getInstance().updateBatchTaskToRunning(bpaInstTaskDao, ctx.getSzBatchSn(), ctx.getSzTaskId());
            if (!this.callPlugin(ctx)) {
                PluginLogService.getInstance().updateBatchTaskToEnd(bpaInstTaskDao, taskInst.getBpaSerialNo(), taskConf, ctx.getStartMills(), "7");
                bFinished = false;
                break;
            }
            PluginLogService.getInstance().updateBatchTaskToEnd(bpaInstTaskDao, taskInst.getBpaSerialNo(), taskConf, ctx.getStartMills(), "6");
            this.logger.debug(taskInst.getBpaSerialNo() + "\u81ea\u52a8\u6d41\u7a0b\u666e\u901a\u4efb\u52a1:" + taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
        }
        BpaInstInfo bpaInstInfo = new BpaInstInfo();
        bpaInstInfo.setBpaSerialNo(this.bpaSerialNo);
        BpaInstInfoDao bpaInstInfoDao = new BpaInstInfoDao(conn);
        BpaInstInfo result = bpaInstInfoDao.queryByPk(bpaInstInfo);
        if (bFinished) {
            result.setBpaState("9");
            result.setEndTime(TimeUtil.getCurrentDateTime());
            bpaInstInfoDao.updateByPk(result);
        } else {
            result.setBpaState("1");
            bpaInstInfoDao.updateByPk(result);
        }
        return bFinished;
    }

    private boolean callPlugin(PluginContext ctx) {
        boolean bIsCallSuccess = false;
        try {
            bIsCallSuccess = PluginExecutor.callPlugin(ctx);
        }
        catch (SQLException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            bIsCallSuccess = false;
            e.printStackTrace();
        }
        return bIsCallSuccess;
    }

    private void doContinueBpaProcess() throws Exception {
        Connection conn = null;
        Object sql = null;
        ArrayList values = new ArrayList();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            BpaBaseInfoDao bpaBaseInfoDao = new BpaBaseInfoDao(conn);
            BpaBaseInfo bpaBaseInfo = new BpaBaseInfo();
            bpaBaseInfo.setBpaId(this.bpaId);
            BpaBaseInfo batchConfig = bpaBaseInfoDao.queryByPk(bpaBaseInfo);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u81ea\u52a8\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u81ea\u52a8\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BpaInstTaskDao bpaInstTaskDao = new BpaInstTaskDao(conn);
            BpaInstTask bpaInstTask = new BpaInstTask();
            bpaInstTask.setBpaSerialNo(this.bpaSerialNo);
            BpaInstTask result = bpaInstTaskDao.queryByPk(bpaInstTask);
            if (result.getTaskRunState() == "7") {
                result.setTaskRunState("1");
                result.setStartTime("");
                result.setEndTime("");
                result.setCostTime(null);
                bpaInstTaskDao.updateByPk(result);
            }
            String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
            BpaRunProcess batRunProcess = new BpaRunProcess(this.bpaSerialNo, batchConfig, logPath);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public void dataMove(Connection conn, String srcTableName, String destTableName, String cond) throws SQLException {
        TableMove dataMoveInst = DataMoveUtil.createTableMoveInst(conn, srcTableName, destTableName);
        dataMoveInst.setCondition(cond);
        dataMoveInst.executeCut();
    }
}

