/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.dao;

import com.irdstudio.bfp.executor.domain.BpmNodeInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmNodeInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(BpmNodeInfoDao.class);
    Connection conn = null;

    public BpmNodeInfoDao(Connection conn) {
        this.conn = conn;
    }

    public BpmNodeInfo queryWithKeys(String bpmNodeId) throws SQLException {
        BpmNodeInfo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bpm_node_info WHERE bpm_node_id=?");
            ps.setString(1, bpmNodeId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BpmNodeInfo();
                dc.setBpmNodeId(rs.getString("bpm_node_id"));
                dc.setBpmNodeCode(rs.getString("bpm_node_code"));
                dc.setBpmNodeName(rs.getString("bpm_node_name"));
                dc.setBpmNodeType(rs.getString("bpm_node_type"));
                dc.setBpmNodeParam(rs.getString("bpm_node_param"));
                dc.setBpmId(rs.getString("bpm_id"));
                dc.setX(rs.getInt("x"));
                dc.setY(rs.getInt("y"));
                dc.setH(rs.getInt("h"));
                dc.setW(rs.getInt("w"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBpmNodeInfoWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

