/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.dao;

import com.irdstudio.bfp.executor.domain.PluginDefine;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDefineDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginDefineDao.class);
    Connection conn = null;

    public PluginDefineDao(Connection conn) {
        this.conn = conn;
    }

    public PluginDefine queryWithKeys(String pluginId) throws SQLException {
        PluginDefine dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_define WHERE plugin_id=?");
            ps.setString(1, pluginId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginDefine();
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setPluginName(rs.getString("plugin_name"));
                dc.setPluginClass(rs.getString("plugin_class"));
                dc.setPluginDesc(rs.getString("plugin_desc"));
                dc.setNeedOtherDsVar(rs.getString("need_other_ds_var"));
                dc.setPluginConfigUrl(rs.getString("plugin_config_url"));
                dc.setPluginCatalog(rs.getString("plugin_catalog"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginDefineWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginDefine> queryWithPluginId(String plugin_id) throws SQLException {
        ArrayList<PluginDefine> dcList = new ArrayList<PluginDefine>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_define WHERE plugin_id=? ");
            ps.setString(1, plugin_id);
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginDefine dc = new PluginDefine();
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setPluginName(rs.getString("plugin_name"));
                dc.setPluginClass(rs.getString("plugin_class"));
                dc.setPluginDesc(rs.getString("plugin_desc"));
                dc.setNeedOtherDsVar(rs.getString("need_other_ds_var"));
                dc.setPluginConfigUrl(rs.getString("plugin_config_url"));
                dc.setPluginCatalog(rs.getString("plugin_catalog"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginDefineList is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

