/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.http.impl;

import com.irdstudio.bfp.executor.service.http.impl.AbstractHttpClientService;
import com.irdstudio.bfp.executor.util.JacksonUtility;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class DefaultHttpURLConnectionClientService<I, O>
extends AbstractHttpClientService<I, O> {
    private int connectTimeout = 30000;
    private int readTimeout = 30000;
    private String charset = "UTF-8";
    private Map<String, String> headers = new HashMap<String, String>();

    @Override
    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    @Override
    public O sendAndReceive(String strUrl, I inArgs, Class<O> clazz) throws Exception {
        URL url = new URL(strUrl);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        String sendJson = JacksonUtility.serializeObjectToJson(inArgs);
        httpURLConnection.connect();
        httpURLConnection.getOutputStream().write(sendJson.getBytes(this.charset));
        httpURLConnection.getOutputStream().flush();
        httpURLConnection.getOutputStream().close();
        InputStream in = httpURLConnection.getInputStream();
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer, 0, buffer.length)) != -1) {
            sb.append(new String(buffer, 0, length, this.charset));
        }
        in.close();
        O outObject = JacksonUtility.deserializeJsonToObject(sb.toString(), clazz);
        return outObject;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

