/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.http.impl;

import com.irdstudio.bfp.executor.service.http.impl.AbstractHttpClientService;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultSpringRestHttpClientService<I, O>
extends AbstractHttpClientService<I, O> {
    HttpHeaders headers = new HttpHeaders();
    private String charset;

    @Override
    public void setHeader(String key, String value) {
        this.headers.set(key, value);
    }

    @Override
    public O sendAndReceive(String url, I inArgs, Class<O> clazz) throws Exception {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
        List messageConverters = restTemplate.getMessageConverters();
        Iterator iterator = messageConverters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter converter = (HttpMessageConverter)iterator.next();
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            iterator.remove();
        }
        messageConverters.add(new StringHttpMessageConverter(Charset.forName(this.charset)));
        HttpEntity entity = new HttpEntity(inArgs, (MultiValueMap)this.headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, entity, clazz, new Object[0]);
        HttpStatus status = responseEntity.getStatusCode();
        if (status.is2xxSuccessful()) {
            return (O)responseEntity.getBody();
        }
        throw new Exception(status.toString());
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

