/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.message.impl;

import com.irdstudio.bfp.executor.service.message.IDataConvert;
import com.irdstudio.bfp.executor.util.BitUtils;
import java.nio.ByteBuffer;

public class DefaultDataConvert
implements IDataConvert {
    private int headBytesLength;
    private boolean lengthContainsHeadBytes = false;

    @Override
    public byte[] read(ByteBuffer buffer) {
        int actLength = 0;
        int bufferLen = buffer.position();
        if (bufferLen < this.headBytesLength) {
            return null;
        }
        buffer.flip();
        byte[] headBytes = new byte[this.headBytesLength];
        buffer.get(headBytes);
        actLength = BitUtils.getInt(headBytes);
        if (this.lengthContainsHeadBytes) {
            actLength -= this.headBytesLength;
        }
        if (bufferLen < actLength || actLength > buffer.remaining()) {
            return null;
        }
        byte[] bytes = new byte[actLength];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public ByteBuffer write(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.headBytesLength + bytes.length);
        byte[] headBytes = new byte[this.headBytesLength];
        BitUtils.putInt(headBytes, bytes.length);
        byteBuffer.put(headBytes);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    public int getHeadBytesLength() {
        return this.headBytesLength;
    }

    public void setHeadBytesLength(int headBytesLength) {
        this.headBytesLength = headBytesLength;
    }

    public boolean isLengthContainsHeadBytes() {
        return this.lengthContainsHeadBytes;
    }

    public void setLengthContainsHeadBytes(boolean lengthContainsHeadBytes) {
        this.lengthContainsHeadBytes = lengthContainsHeadBytes;
    }
}

