/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.socket.handler;

import com.irdstudio.bfp.executor.service.message.IDataConvert;
import com.irdstudio.bfp.executor.service.message.IMessagePacker;
import com.irdstudio.bfp.executor.service.socket.handler.AbstractMeepwnClientInChannelHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySocketClientChannelHandler
extends AbstractMeepwnClientInChannelHandler {
    private static Logger logger = LoggerFactory.getLogger(NettySocketClientChannelHandler.class);
    private IDataConvert dataConvert;
    private IMessagePacker messagePacker;
    private byte[] hasReadBytes = new byte[0];
    private boolean readComplete = false;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.hasReadBytes.length + buf.readableBytes());
        byteBuffer.put(this.hasReadBytes);
        byte[] readableBytes = new byte[buf.readableBytes()];
        buf.readBytes(readableBytes);
        byteBuffer.put(readableBytes);
        byte[] bytes = this.dataConvert.read(byteBuffer);
        if (Objects.nonNull(bytes)) {
            this.hasReadBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.hasReadBytes, 0, bytes.length);
            this.readComplete = true;
        } else {
            this.hasReadBytes = byteBuffer.array();
        }
        buf.release();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.info("connect success!");
        super.channelActive(ctx);
        while (true) {
            if (this.isWrite()) break;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        byte[] writeBytes = (byte[])this.messagePacker.pack(this.getOutMessage());
        ByteBuffer byteBuf = this.dataConvert.write(writeBytes);
        byte[] bytes = new byte[byteBuf.position()];
        byteBuf.flip();
        byteBuf.get(bytes);
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])bytes));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.readComplete) {
            Serializable inMessage = this.messagePacker.unpack(this.hasReadBytes);
            this.setInMessage(inMessage);
            this.setRead(true);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("server occur exception!", cause);
        this.setRead(true);
        ctx.close();
    }

    public IDataConvert getDataConvert() {
        return this.dataConvert;
    }

    public void setDataConvert(IDataConvert dataConvert) {
        this.dataConvert = dataConvert;
    }

    public IMessagePacker getMessagePacker() {
        return this.messagePacker;
    }

    public void setMessagePacker(IMessagePacker messagePacker) {
        this.messagePacker = messagePacker;
    }
}

