/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.socket.handler;

import com.irdstudio.bfp.executor.service.message.IBusinessMessage;
import com.irdstudio.bfp.executor.service.message.IBusinessProcess;
import com.irdstudio.bfp.executor.service.message.IDataConvert;
import com.irdstudio.bfp.executor.service.message.IMessagePacker;
import com.irdstudio.bfp.executor.thread.Result;
import com.irdstudio.bfp.executor.thread.pool.ThreadPool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySocketServerChannelHandler
extends ChannelInboundHandlerAdapter {
    private static Logger logger = LoggerFactory.getLogger(NettySocketServerChannelHandler.class);
    private IDataConvert dataConvert;
    private IMessagePacker messagePacker;
    private IBusinessProcess businessProcess;
    private ThreadPool threadPool;
    private boolean readComplete = false;
    private byte[] hasReadBytes = new byte[0];
    private boolean async = false;

    public void channelActive(ChannelHandlerContext context) throws Exception {
        logger.info("server channel active... ");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.hasReadBytes.length + buf.readableBytes());
        byteBuffer.put(this.hasReadBytes);
        byte[] readableBytes = new byte[buf.readableBytes()];
        buf.readBytes(readableBytes);
        byteBuffer.put(readableBytes);
        byte[] bytes = this.dataConvert.read(byteBuffer);
        if (Objects.nonNull(bytes)) {
            this.hasReadBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.hasReadBytes, 0, bytes.length);
            this.readComplete = true;
        } else {
            this.hasReadBytes = byteBuffer.array();
        }
        buf.release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.readComplete) {
            this.readComplete = false;
            Serializable inMessage = this.messagePacker.unpack(this.hasReadBytes);
            Serializable outMessage = null;
            if (this.async) {
                IBusinessMessage businessMessage = (IBusinessMessage)((Object)this.businessProcess);
                businessMessage.setInMessage(inMessage);
                Future<Result<?>> future = this.threadPool.add((Callable)((Object)businessMessage));
                Result<?> result = future.get();
                if (!result.isSuccess()) throw new Exception(result.errorMessage());
                outMessage = (Serializable)result.getResult();
            } else {
                outMessage = this.businessProcess.process(inMessage);
            }
            byte[] writeBytes = (byte[])this.messagePacker.pack(outMessage);
            ByteBuffer byteBuf = this.dataConvert.write(writeBytes);
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])byteBuf.array()));
        }
        super.channelReadComplete(ctx);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("server occur exception:" + cause.getMessage());
        ctx.close();
    }

    public IDataConvert getDataConvert() {
        return this.dataConvert;
    }

    public void setDataConvert(IDataConvert dataConvert) {
        this.dataConvert = dataConvert;
    }

    public IMessagePacker getMessagePacker() {
        return this.messagePacker;
    }

    public void setMessagePacker(IMessagePacker messagePacker) {
        this.messagePacker = messagePacker;
    }

    public IBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(IBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }
}

