/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.socket.impl;

import com.irdstudio.bfp.executor.service.message.IDataConvert;
import com.irdstudio.bfp.executor.service.message.IMessagePacker;
import com.irdstudio.bfp.executor.service.socket.SocketClientService;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaNioSocketClientService
implements SocketClientService {
    private SocketChannel client;
    private Selector selector;
    private ThreadPoolExecutor threadPool = new ThreadPoolExecutor(5, 10, 200L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(20));
    private volatile boolean isClose = false;
    private AtomicLong writeCount = new AtomicLong(0L);
    private AtomicLong readCount = new AtomicLong(0L);
    private AtomicBoolean isWriting = new AtomicBoolean(false);
    private AtomicBoolean isReading = new AtomicBoolean(false);
    private AtomicBoolean isReadEnd = new AtomicBoolean(false);
    private IMessagePacker messagePacker;
    private IDataConvert dataConvert;
    private String ip;
    private int port;
    private int timeout;
    private static Logger logger = LoggerFactory.getLogger(JavaNioSocketClientService.class);
    private Object readData;

    public Selector getSelector() throws IOException {
        try {
            return Selector.open();
        }
        catch (IOException e) {
            logger.error("nio select create exception!", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void start() {
        try {
            this.client = SocketChannel.open();
            this.client.configureBlocking(false);
            this.client.socket().setSoTimeout(this.timeout);
            this.client.connect(new InetSocketAddress(this.ip, this.port));
            this.selector = this.getSelector();
            this.client.register(this.selector, 8);
        }
        catch (IOException e) {
            logger.error("Ip:" + this.ip + " Port:" + this.port + " Connection refused! execute exit", (Throwable)e);
            this.close();
        }
        this.threadPool.execute(new SelectorGuardHandler());
    }

    private void setReadData(Object obj) {
        this.readData = obj;
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean close) {
        this.isClose = close;
    }

    public void close() {
        try {
            this.threadPool.shutdown();
            this.isClose = true;
            if (Objects.nonNull(this.selector)) {
                this.selector.close();
            }
            if (Objects.nonNull(this.client)) {
                this.client.close();
            }
        }
        catch (IOException e) {
            logger.error("Close client occur eception!", (Throwable)e);
        }
    }

    public void writeData(Object data) {
        while (this.isWriting.get()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.isWriting.set(true);
            this.writeCount.incrementAndGet();
            this.client.register(this.selector, 4, data);
        }
        catch (Exception e) {
            logger.error("Client register and writer Channel occur exception, will exit!", (Throwable)e);
            this.close();
        }
    }

    public Object getReadData() {
        return this.readData;
    }

    public AtomicBoolean getIsReadEnd() {
        return this.isReadEnd;
    }

    public void setIsReadEnd(AtomicBoolean isReadEnd) {
        this.isReadEnd = isReadEnd;
    }

    public boolean hasWriteTask() {
        return this.writeCount.get() != 0L;
    }

    public long getRecive() {
        return this.readCount.get();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isReadEnd() {
        return this.isReadEnd.get();
    }

    @Override
    public void stop() {
        this.close();
    }

    @Override
    public Object sendAndReceive(Serializable sendMessage) {
        while (this.isWriting.get()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.isWriting.set(true);
            this.writeCount.incrementAndGet();
            this.client.register(this.selector, 4, sendMessage);
            while (!this.isReadEnd()) {
                Thread.sleep(100L);
            }
            return (Serializable)this.getReadData();
        }
        catch (Exception e) {
            logger.error("Client register and writer Channel occur exception, will exit!", (Throwable)e);
            this.close();
            return null;
        }
    }

    public SocketChannel getClient() {
        return this.client;
    }

    public void setClient(SocketChannel client) {
        this.client = client;
    }

    public IMessagePacker getMessagePacker() {
        return this.messagePacker;
    }

    public void setMessagePacker(IMessagePacker messagePacker) {
        this.messagePacker = messagePacker;
    }

    public IDataConvert getDataConvert() {
        return this.dataConvert;
    }

    public void setDataConvert(IDataConvert dataConvert) {
        this.dataConvert = dataConvert;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private class ReceiveMessageHandler
    implements Runnable {
        private SocketChannel client;
        private ByteBuffer byteBuf = ByteBuffer.allocate(1024);

        private ReceiveMessageHandler(SocketChannel client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.byteBuf.capacity());
                this.client.read(this.byteBuf);
                byteBuffer.put(this.byteBuf.array());
                byte[] bytes = JavaNioSocketClientService.this.dataConvert.read(byteBuffer);
                while (Objects.isNull(bytes)) {
                    this.byteBuf.clear();
                    this.client.read(this.byteBuf);
                    byte[] bs = byteBuffer.array();
                    byteBuffer = ByteBuffer.allocate(bs.length + 1024);
                    byteBuffer.put(bs);
                    byteBuffer.put(this.byteBuf.array());
                    bytes = JavaNioSocketClientService.this.dataConvert.read(byteBuffer);
                }
                Serializable object = JavaNioSocketClientService.this.messagePacker.unpack(bytes);
                JavaNioSocketClientService.this.setReadData(object);
                logger.debug("Read service return message finish!");
                JavaNioSocketClientService.this.readCount.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("Client receive message occured exception, will exit!", (Throwable)e);
                JavaNioSocketClientService.this.close();
            }
            finally {
                JavaNioSocketClientService.this.isReading.set(false);
                JavaNioSocketClientService.this.isReadEnd.set(true);
            }
        }
    }

    private class SendMessageHandler
    implements Runnable {
        private SocketChannel client;
        private Object requestMessage;

        public SendMessageHandler(SocketChannel client, Object requestMessage) {
            this.client = client;
            this.requestMessage = (Serializable)requestMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] requestMessageByteData = (byte[])this.requestMessage;
                if (Objects.isNull(requestMessageByteData) || requestMessageByteData.length == 0) {
                    logger.error("Current send message is null!");
                    throw new NullPointerException("Current send message is null!");
                }
                Object object = JavaNioSocketClientService.this.messagePacker.pack((Serializable)requestMessageByteData);
                ByteBuffer bytebuf = JavaNioSocketClientService.this.dataConvert.write((byte[])object);
                bytebuf.flip();
                while (bytebuf.hasRemaining()) {
                    this.client.write(bytebuf);
                }
                bytebuf.clear();
                logger.debug("Current send message has finished!");
            }
            catch (Exception e) {
                logger.error("Current send message occured exceptin, will exit!", (Throwable)e);
                JavaNioSocketClientService.this.close();
            }
            finally {
                JavaNioSocketClientService.this.isWriting.set(false);
                JavaNioSocketClientService.this.writeCount.decrementAndGet();
            }
        }
    }

    public class SelectorGuardHandler
    implements Runnable {
        @Override
        public void run() {
            while (!JavaNioSocketClientService.this.isClose) {
                try {
                    if (JavaNioSocketClientService.this.selector.select(10L) == 0) continue;
                    JavaNioSocketClientService.this.selector.select();
                    Iterator<SelectionKey> iterator = JavaNioSocketClientService.this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SocketChannel socketChannel;
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (selectionKey.isReadable()) {
                            socketChannel = (SocketChannel)selectionKey.channel();
                            if (JavaNioSocketClientService.this.isReading.get()) {
                                Thread.sleep(5L);
                                continue;
                            }
                            JavaNioSocketClientService.this.isReading.set(true);
                            JavaNioSocketClientService.this.threadPool.execute(new ReceiveMessageHandler(socketChannel));
                            continue;
                        }
                        if (selectionKey.isWritable()) {
                            Object requestMessage = selectionKey.attachment();
                            SocketChannel socketChannel2 = (SocketChannel)selectionKey.channel();
                            selectionKey.interestOps(1);
                            JavaNioSocketClientService.this.threadPool.execute(new SendMessageHandler(socketChannel2, requestMessage));
                            continue;
                        }
                        if (!selectionKey.isConnectable()) continue;
                        socketChannel = (SocketChannel)selectionKey.channel();
                        socketChannel.finishConnect();
                        socketChannel.register(JavaNioSocketClientService.this.selector, 1);
                    }
                }
                catch (Exception e) {
                    logger.error("nio socket client start and running exception, will exit!", (Throwable)e);
                    JavaNioSocketClientService.this.close();
                }
            }
        }
    }
}

