/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.socket.impl;

import com.irdstudio.bfp.executor.service.message.IDataConvert;
import com.irdstudio.bfp.executor.service.message.IMessagePacker;
import com.irdstudio.bfp.executor.service.socket.SocketClientService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSocketClientService
implements SocketClientService {
    private static Logger logger = LoggerFactory.getLogger(JavaSocketClientService.class);
    Socket socket = null;
    private String host;
    private int port;
    private int timeout;
    private IMessagePacker messagePacker;
    private IDataConvert dataConvert;
    int bufferSize = 1024;
    private byte[] hasReadBytes = new byte[0];
    private boolean readComplete = false;

    @Override
    public void start() {
        try {
            SocketFactory factory = SocketFactory.getDefault();
            this.socket = factory.createSocket();
            this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    @Override
    public Object sendAndReceive(Serializable sendMessage) throws Exception {
        if (Objects.isNull(this.socket) || !this.socket.isConnected()) {
            logger.error("host: " + this.host + " port: " + this.port + " not connected!");
            throw new Exception("host: " + this.host + " port: " + this.port + " not connected!");
        }
        byte[] sendBytes = (byte[])this.messagePacker.pack(sendMessage);
        ByteBuffer sendByteBuffer = this.dataConvert.write(sendBytes);
        sendByteBuffer.flip();
        this.sendMessage(sendByteBuffer.array());
        return this.readMessage();
    }

    public void sendMessage(byte[] contents) throws Exception {
        OutputStream out = null;
        try {
            out = this.socket.getOutputStream();
            this.writeContent(out, this.bufferSize, contents);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeContent(OutputStream out, int bufferSize, byte[] contents) throws Exception {
        int writeSize;
        byte[] buffer = new byte[bufferSize];
        int offset = 0;
        while ((writeSize = Math.min(bufferSize, contents.length - offset)) > 0) {
            System.arraycopy(contents, offset, buffer, 0, writeSize);
            out.write(buffer, 0, writeSize);
            offset += writeSize;
        }
    }

    private Object readMessage() throws Exception {
        while (!this.readComplete) {
            this.readContent();
        }
        Serializable outMessage = this.messagePacker.unpack(this.hasReadBytes);
        return outMessage;
    }

    private void readContent() throws Exception {
        InputStream in = null;
        try {
            in = this.socket.getInputStream();
            int readableBytesLength = in.available();
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.hasReadBytes.length + readableBytesLength);
            byte[] readBytes = new byte[readableBytesLength];
            in.read(readBytes);
            byteBuffer.put(readBytes);
            byte[] bytes = this.dataConvert.read(byteBuffer);
            if (Objects.nonNull(bytes)) {
                this.hasReadBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, this.hasReadBytes, 0, bytes.length);
                this.readComplete = true;
            } else {
                this.hasReadBytes = byteBuffer.array();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public IMessagePacker getMessagePacker() {
        return this.messagePacker;
    }

    public void setMessagePacker(IMessagePacker messagePacker) {
        this.messagePacker = messagePacker;
    }

    public IDataConvert getDataConvert() {
        return this.dataConvert;
    }

    public void setDataConvert(IDataConvert dataConvert) {
        this.dataConvert = dataConvert;
    }
}

