/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.socket.impl;

import com.irdstudio.bfp.executor.service.socket.SocketClientService;
import com.irdstudio.bfp.executor.service.socket.handler.AbstractMeepwnClientInChannelHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySocketClientService
implements SocketClientService {
    private int port;
    private String host;
    SocketChannel socketChannel;
    Bootstrap bootstrap;
    private AbstractMeepwnClientInChannelHandler channelHandler;
    EventLoopGroup group = new NioEventLoopGroup();
    private static Logger logger = LoggerFactory.getLogger(NettySocketClientService.class);
    private boolean isConnect = false;
    private static long DEFAULT_ALL_TIME_OUT = 30L;
    private long readTimeOut = 10L;
    private long writeTimeOut = 10L;
    private long allTimeOut = 30L;

    @Override
    public void start() {
        block5: {
            try {
                ChannelFuture future = null;
                this.bootstrap = new Bootstrap();
                this.bootstrap.channel(NioSocketChannel.class);
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)5120)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)5120)).option(ChannelOption.SO_RCVBUF, (Object)5120)).option(EpollChannelOption.SO_REUSEPORT, (Object)true);
                this.bootstrap.group(this.group);
                this.bootstrap.remoteAddress(this.host, this.port);
                this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel socketChannel) throws Exception {
                        socketChannel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(NettySocketClientService.this.readTimeOut, NettySocketClientService.this.writeTimeOut, NettySocketClientService.this.allTimeOut, TimeUnit.SECONDS)});
                        socketChannel.pipeline().addLast(new ChannelHandler[]{NettySocketClientService.this.channelHandler});
                    }
                });
                future = this.bootstrap.connect(this.host, this.port).sync();
                if (future.isSuccess()) {
                    this.socketChannel = (SocketChannel)future.channel();
                    this.isConnect = true;
                    logger.info("host: " + this.host + " port: " + this.port + "connect server success!");
                    break block5;
                }
                logger.info("host: " + this.host + " port: " + this.port + "connect server failure!");
                this.isConnect = false;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        if (Objects.nonNull(this.socketChannel)) {
            this.socketChannel.close();
        }
        try {
            this.group.shutdownGracefully().sync();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object sendAndReceive(Serializable sendMessage) throws Exception {
        if (!this.isConnect) {
            throw new Exception("host: " + this.host + " port: " + this.port + "connect server failure!");
        }
        this.channelHandler.setOutMessage(sendMessage);
        this.channelHandler.setWrite(true);
        Serializable rtnMessage = null;
        while (true) {
            if (this.channelHandler.isRead()) break;
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        rtnMessage = this.channelHandler.getInMessage();
        this.channelHandler.setRead(false);
        return rtnMessage;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public AbstractMeepwnClientInChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public void setChannelHandler(AbstractMeepwnClientInChannelHandler channelHandler) {
        this.channelHandler = channelHandler;
    }

    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public long getWriteTimeOut() {
        return this.writeTimeOut;
    }

    public void setWriteTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
    }

    public long getAllTimeOut() {
        return this.allTimeOut;
    }

    public void setAllTimeOut(long allTimeOut) {
        this.allTimeOut = this.readTimeOut + this.writeTimeOut > allTimeOut ? DEFAULT_ALL_TIME_OUT : allTimeOut;
    }
}

