/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.service.socket.impl;

import com.irdstudio.bfp.executor.service.socket.SocketServerService;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class NettySocketServerService
implements SocketServerService {
    private int port;
    private String channelHandler;
    private int connThreadNum;
    private int workThreadNum;
    EventLoopGroup pGroup;
    EventLoopGroup cGroup;
    ChannelFuture cf;
    private static long DEFAULT_ALL_TIME_OUT = 30L;
    private long readTimeOut = 10L;
    private long writeTimeOut = 10L;
    private long allTimeOut = 30L;

    @Override
    public void start() {
        this.pGroup = new NioEventLoopGroup(this.connThreadNum);
        this.cGroup = new NioEventLoopGroup(this.workThreadNum);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.pGroup, this.cGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)12288)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)12288)).option(ChannelOption.SO_RCVBUF, (Object)12288)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.SO_REUSEPORT, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(NettySocketServerService.this.readTimeOut, NettySocketServerService.this.writeTimeOut, NettySocketServerService.this.allTimeOut, TimeUnit.SECONDS)});
                ChannelHandlerAdapter adapter = (ChannelHandlerAdapter)SpringContextUtils.getBean((String)NettySocketServerService.this.channelHandler, ChannelHandlerAdapter.class);
                socketChannel.pipeline().addLast(new ChannelHandler[]{adapter});
            }
        });
        try {
            this.cf = b.bind(this.port).sync();
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(NettySocketServerService.class).error(e.getMessage(), (Throwable)e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void stop() {
        try {
            this.cf.channel().closeFuture().sync();
            this.pGroup.shutdownGracefully();
            this.cGroup.shutdownGracefully();
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(NettySocketServerService.class).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        this.stop();
    }

    public int getConnThreadNum() {
        return this.connThreadNum;
    }

    public void setConnThreadNum(int connThreadNum) {
        this.connThreadNum = connThreadNum;
    }

    public int getWorkThreadNum() {
        return this.workThreadNum;
    }

    public void setWorkThreadNum(int workThreadNum) {
        this.workThreadNum = workThreadNum;
    }

    public String getChannelHandler() {
        return this.channelHandler;
    }

    public void setChannelHandler(String channelHandler) {
        this.channelHandler = channelHandler;
    }

    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public long getWriteTimeOut() {
        return this.writeTimeOut;
    }

    public void setWriteTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
    }

    public long getAllTimeOut() {
        return this.allTimeOut;
    }

    public void setAllTimeOut(long allTimeOut) {
        this.allTimeOut = this.readTimeOut + this.writeTimeOut > allTimeOut ? DEFAULT_ALL_TIME_OUT : allTimeOut;
    }
}

